/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.pcm.extension.editor.sirius.assignments;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.stoex.StoexFactory;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.CharacteristicType;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.EnumCharacteristicType;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.Literal;
import org.dataflowanalysis.pcm.extension.dictionary.characterized.DataDictionaryCharacterized.expressions.EnumCharacteristicReference;
import org.dataflowanalysis.pcm.extension.model.confidentiality.behaviour.BehaviourFactory;
import org.dataflowanalysis.pcm.extension.model.confidentiality.behaviour.ReusableBehaviour;
import org.dataflowanalysis.pcm.extension.model.confidentiality.characteristics.CharacteristicTypeDictionary;
import org.dataflowanalysis.pcm.extension.model.confidentiality.dictionary.DictionaryFactory;
import org.dataflowanalysis.pcm.extension.model.confidentiality.dictionary.PCMDataDictionary;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.util.StringInputStream;
import org.palladiosimulator.pcm.parameter.VariableUsage;

public final class SerializationHelper {
    private final IEditedResourceProvider editedResourceProvider;

    public SerializationHelper(IEditedResourceProvider editedResourceProvider) {
        this.editedResourceProvider = editedResourceProvider;
    }

    public PCMDataDictionary buildSerializationModel(Consumer<ReusableBehaviour> behaviorBuilder, String lhsName, Collection<String> inputs, Collection<CharacteristicTypeDictionary> dictionaries) {
        PCMDataDictionary dict = DictionaryFactory.eINSTANCE.createPCMDataDictionary();
        for (CharacteristicTypeDictionary dictionary : dictionaries) {
            CharacteristicTypeDictionary copy = (CharacteristicTypeDictionary)EcoreUtil.copy((EObject)dictionary);
            dict.getCharacteristicEnumerations().addAll((Collection)copy.getCharacteristicEnumerations());
            dict.getCharacteristicTypes().addAll((Collection)copy.getCharacteristicTypes());
        }
        ReusableBehaviour behaviour = BehaviourFactory.eINSTANCE.createReusableBehaviour();
        dict.getReusableBehaviours().add((Object)behaviour);
        behaviour.setEntityName("foo");
        behaviour.getOutputVariables().add((Object)SerializationHelper.createVariableReferenceFromString(lhsName));
        inputs.stream().map(SerializationHelper::createVariableReferenceFromString).forEach(arg_0 -> behaviour.getInputVariables().add(arg_0));
        behaviorBuilder.accept(behaviour);
        return dict;
    }

    public PCMDataDictionary parseDict(String text, Collection<CharacteristicTypeDictionary> dictionaries) throws IOException {
        PCMDataDictionary parsedDict = this.parseDict(text);
        Collection<VariableUsage> parsedVariableUsages = SerializationHelper.findVariableUsages(parsedDict);
        parsedVariableUsages.forEach(usage -> SerializationHelper.replaceCharacteristicTypes(usage, dictionaries));
        return parsedDict;
    }

    public String serializeDict(PCMDataDictionary dict, Collection<CharacteristicTypeDictionary> dictionaries) throws IOException {
        PCMDataDictionary copy = (PCMDataDictionary)EcoreUtil.copy((EObject)dict);
        ArrayList<CharacteristicTypeDictionary> dictionariestoUse = new ArrayList<CharacteristicTypeDictionary>(dictionaries);
        if (dictionariestoUse.contains(dict)) {
            dictionariestoUse.remove(dict);
            dictionariestoUse.add((CharacteristicTypeDictionary)copy);
        }
        Collection<VariableUsage> variableUsages = SerializationHelper.findVariableUsages(copy);
        variableUsages.forEach(usage -> SerializationHelper.replaceCharacteristicTypes(usage, dictionariestoUse));
        return this.serializeDict(copy);
    }

    protected PCMDataDictionary parseDict(String text) throws IOException {
        XtextResource r = this.editedResourceProvider.createResource();
        Throwable throwable = null;
        Object var4_5 = null;
        try (StringInputStream is = new StringInputStream(text);){
            r.load((InputStream)is, Collections.emptyMap());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return (PCMDataDictionary)r.getContents().get(0);
    }

    protected String serializeDict(PCMDataDictionary dict) throws IOException {
        XtextResource r = this.editedResourceProvider.createResource();
        r.getContents().add((Object)dict);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            r.save((OutputStream)baos, Collections.emptyMap());
            return baos.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static void replaceCharacteristicTypes(VariableUsage variableUsage, Collection<CharacteristicTypeDictionary> dictionaries) {
        SerializationHelper.eAllContentsStream((EObject)variableUsage).filter(EnumCharacteristicReference.class::isInstance).map(EnumCharacteristicReference.class::cast).forEach(reference -> {
            if (reference.getCharacteristicType() != null) {
                Optional<EnumCharacteristicType> foundCharacteristicType = SerializationHelper.findCharacteristicTypeInDicts(reference.getCharacteristicType().getName(), dictionaries).filter(EnumCharacteristicType.class::isInstance).map(EnumCharacteristicType.class::cast);
                assert (foundCharacteristicType.isPresent());
                foundCharacteristicType.ifPresent(arg_0 -> ((EnumCharacteristicReference)reference).setCharacteristicType(arg_0));
                if (foundCharacteristicType.isPresent() && reference.getLiteral() != null) {
                    Optional<Literal> foundLiteral = foundCharacteristicType.get().getType().getLiterals().stream().filter(l -> reference.getLiteral().getName().equals(l.getName())).findFirst();
                    assert (foundLiteral.isPresent());
                    foundLiteral.ifPresent(arg_0 -> ((EnumCharacteristicReference)reference).setLiteral(arg_0));
                }
            }
        });
        SerializationHelper.eAllContentsStream((EObject)variableUsage).filter(Identifier.class::isInstance).map(Identifier.class::cast).forEach(i -> i.setId(EcoreUtil.generateUUID()));
    }

    protected static Optional<CharacteristicType> findCharacteristicTypeInDicts(String name, Collection<CharacteristicTypeDictionary> dictionaries) {
        return dictionaries.stream().map(dict -> SerializationHelper.findCharacteristicTypeInDict(name, dict)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    protected static Optional<CharacteristicType> findCharacteristicTypeInDict(String name, CharacteristicTypeDictionary dict) {
        return dict.getCharacteristicTypes().stream().filter(ct -> name.equals(ct.getName())).findFirst();
    }

    protected static Collection<VariableUsage> findVariableUsages(PCMDataDictionary dictionary) {
        return SerializationHelper.eAllContentsStream((EObject)dictionary).filter(VariableUsage.class::isInstance).map(VariableUsage.class::cast).collect(Collectors.toList());
    }

    protected static Stream<EObject> eAllContentsStream(EObject object) {
        TreeIterator iter = object.eAllContents();
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iter, 16);
        return StreamSupport.stream(spliterator, false);
    }

    protected static VariableReference createVariableReferenceFromString(String name) {
        VariableReference varRef = StoexFactory.eINSTANCE.createVariableReference();
        varRef.setReferenceName(name);
        return varRef;
    }
}

