/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelversioning.emfprofile.IProfileFacade;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.impl.ProfileFacadeImpl;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplicability;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.impl.ProfileApplicationImpl;

public class ProfileApplicationDecoratorImpl
extends ProfileApplicationImpl
implements ProfileApplicationDecorator {
    private final ResourceSet resourceSet;
    private final IProfileFacade facade;
    private final ProfileApplication profileApplication;
    private final IFile profileApplicationFile;
    private boolean dirty = false;
    private final Collection<Profile> profiles;

    public ProfileApplicationDecoratorImpl(IFile profileApplicationFile, Collection<Profile> profiles, ResourceSet resourceSet) throws CoreException, IOException {
        this.profileApplicationFile = profileApplicationFile;
        this.profiles = profiles;
        this.resourceSet = resourceSet;
        this.facade = this.createAndInitializeProfileFacade(profileApplicationFile, profiles);
        this.dirty = true;
        this.profileApplication = this.facade.findOrCreateProfileApplication(profiles.iterator().next());
    }

    public ProfileApplicationDecoratorImpl(IFile profileApplicationFile, ResourceSet resourceSet) throws CoreException, IOException {
        this.profileApplicationFile = profileApplicationFile;
        this.resourceSet = resourceSet;
        this.facade = this.loadProfileApplication(profileApplicationFile);
        this.profiles = this.facade.getLoadedProfiles();
        this.dirty = false;
        if (this.facade.getProfileApplications().isEmpty()) {
            throw new IOException("The file: " + profileApplicationFile.getName() + ", does not contain any profile applications.");
        }
        this.profileApplication = (ProfileApplication)this.facade.getProfileApplications().get(0);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public IFile getProfileApplicationFile() {
        return this.profileApplicationFile;
    }

    private IProfileFacade createAndInitializeProfileFacade(IFile profileApplicationFile, Collection<Profile> profiles) throws CoreException, IOException {
        IProfileFacade facade = this.createNewProfileFacade(profileApplicationFile);
        for (Profile profile : profiles) {
            facade.loadProfile(profile);
        }
        profileApplicationFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return facade;
    }

    private IProfileFacade loadProfileApplication(IFile profileApplicationFile) throws CoreException, IOException {
        profileApplicationFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        IProfileFacade facade = this.createNewProfileFacade(profileApplicationFile);
        return facade;
    }

    private IProfileFacade createNewProfileFacade(IFile profileApplicationFile) throws IOException {
        ProfileFacadeImpl facade = new ProfileFacadeImpl();
        facade.setProfileApplicationFileAndInitializeResource(profileApplicationFile, this.resourceSet);
        return facade;
    }

    @Override
    public String getName() {
        String result = "";
        EList profiles = this.facade.getLoadedProfiles();
        Iterator iter = profiles.iterator();
        while (iter.hasNext()) {
            result = String.valueOf(result) + ((Profile)iter.next()).getName();
            if (!iter.hasNext()) continue;
            result = String.valueOf(result) + ", ";
        }
        return String.valueOf(result) + " - " + this.profileApplicationFile.getLocation().makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation()).toString();
    }

    @Override
    public String getProfileName() {
        return this.profiles.iterator().next().getName();
    }

    public void unload() {
        this.facade.unloadProfile(null);
        this.facade.unload();
    }

    @Override
    public void save() throws IOException, CoreException {
        this.facade.save();
        this.dirty = false;
    }

    @Override
    public Collection<? extends StereotypeApplicability> getApplicableStereotypes(EObject eObject) {
        return this.facade.getApplicableStereotypes(eObject);
    }

    @Override
    public StereotypeApplication applyStereotype(StereotypeApplicability stereotypeApplicability, EObject eObject) {
        StereotypeApplication result = this.facade.apply(stereotypeApplicability, eObject);
        this.dirty = true;
        return result;
    }

    @Override
    public void addNestedEObject(EObject container, EReference eReference, EObject eObject) {
        this.facade.addNestedEObject(container, eReference, eObject);
        this.dirty = true;
    }

    @Override
    public void removeEObject(EObject eObject) {
        this.dirty = true;
        this.facade.removeEObject(eObject);
    }

    public EList<StereotypeApplication> getStereotypeApplications() {
        return this.profileApplication.getStereotypeApplications();
    }

    public EList<ProfileImport> getImportedProfiles() {
        return this.profileApplication.getImportedProfiles();
    }

    public EList<StereotypeApplication> getStereotypeApplications(EObject eObject) {
        return this.profileApplication.getStereotypeApplications(eObject);
    }

    public EList<StereotypeApplication> getStereotypeApplications(EObject eObject, Stereotype stereotype) {
        return this.profileApplication.getStereotypeApplications(eObject, stereotype);
    }

    public EList<EObject> getAnnotatedObjects() {
        return this.profileApplication.getAnnotatedObjects();
    }

    public EClass eClass() {
        return this.profileApplication.eClass();
    }

    public Resource eResource() {
        return this.profileApplication.eResource();
    }

    public EObject eContainer() {
        return this.profileApplication.eContainer();
    }

    public EStructuralFeature eContainingFeature() {
        return this.profileApplication.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.profileApplication.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.profileApplication.eContents();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.profileApplication.eAllContents();
    }

    public boolean eIsProxy() {
        return this.profileApplication.eIsProxy();
    }

    public EList<EObject> eCrossReferences() {
        return this.profileApplication.eCrossReferences();
    }

    public Object eGet(EStructuralFeature feature) {
        return this.profileApplication.eGet(feature);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.profileApplication.eGet(feature, resolve);
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.profileApplication.eSet(feature, newValue);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.profileApplication.eIsSet(feature);
    }

    public void eUnset(EStructuralFeature feature) {
        this.profileApplication.eUnset(feature);
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return this.profileApplication.eInvoke(operation, arguments);
    }

    public EList<Adapter> eAdapters() {
        return this.profileApplication.eAdapters();
    }

    public boolean eDeliver() {
        return this.profileApplication.eDeliver();
    }

    public void eSetDeliver(boolean deliver) {
        this.profileApplication.eSetDeliver(deliver);
    }

    public void eNotify(Notification notification) {
        this.profileApplication.eNotify(notification);
    }

    public ProfileApplication getProfileApplication() {
        return this.profileApplication;
    }
}

