/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.application.registry.ProfileApplicationDecorator;
import org.modelversioning.emfprofile.application.registry.internal.ProfileApplicationDecoratorImpl;

public class ProfileApplicationManager {
    private ResourceSet resourceSet;
    private Collection<ProfileApplicationDecorator> profileApplications = new ArrayList<ProfileApplicationDecorator>();

    public ProfileApplicationManager(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public Collection<ProfileApplicationDecorator> getProfileApplications() {
        return this.profileApplications;
    }

    public boolean hasProfileApplications() {
        return !this.profileApplications.isEmpty();
    }

    public void createNewProfileApplication(IFile profileApplicationFile, Collection<Profile> profiles) throws CoreException, IOException {
        ProfileApplicationDecoratorImpl element = new ProfileApplicationDecoratorImpl(profileApplicationFile, profiles, this.resourceSet);
        this.profileApplications.add(element);
    }

    public ProfileApplicationDecorator loadProfileApplication(IFile profileApplicationFile) throws CoreException, IOException {
        ProfileApplicationDecoratorImpl profileApplication = new ProfileApplicationDecoratorImpl(profileApplicationFile, this.resourceSet);
        this.profileApplications.add(profileApplication);
        return profileApplication;
    }

    public void removeProfileApplication(ProfileApplicationDecorator profileApplication) {
        ProfileApplicationDecoratorImpl profileApplicationImpl = (ProfileApplicationDecoratorImpl)profileApplication;
        profileApplicationImpl.unload();
        this.profileApplications.remove(profileApplication);
    }

    public void dispose() {
        for (ProfileApplicationDecorator profileApplication : this.profileApplications) {
            ((ProfileApplicationDecoratorImpl)profileApplication).unload();
        }
        this.profileApplications.clear();
    }
}

