/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.DataFlowConfidentialityAnalysis;
import org.eclipse.core.runtime.Plugin;

public abstract class DataFlowAnalysisBuilder {
    private final Logger logger = Logger.getLogger(DataFlowAnalysisBuilder.class);
    protected boolean standalone = false;
    protected String modelProjectName = "";
    protected Optional<Class<? extends Plugin>> pluginActivator = Optional.empty();
    protected boolean customResourceProviderIsLoaded = false;

    public DataFlowAnalysisBuilder standalone() {
        this.standalone = true;
        return this;
    }

    public DataFlowAnalysisBuilder modelProjectName(String modelProjectName) {
        this.modelProjectName = modelProjectName;
        return this;
    }

    public DataFlowAnalysisBuilder usePluginActivator(Class<? extends Plugin> activator) {
        this.pluginActivator = Optional.of(activator);
        return this;
    }

    protected void validate() {
        if (!this.standalone) {
            this.logger.error((Object)"The dataflow analysis can only be run in standalone mode", (Throwable)new IllegalStateException("Dataflow analysis can only be run in standalone mode"));
        }
    }

    public abstract DataFlowConfidentialityAnalysis build();
}

