/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis;

import java.util.List;
import java.util.function.Predicate;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.FlowGraphCollection;
import org.dataflowanalysis.analysis.utils.ANSIConsoleLogger;
import org.eclipse.xtext.linking.impl.AbstractCleaningLinker;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.resource.containers.ResourceSetBasedAllContainersStateProvider;

public abstract class DataFlowConfidentialityAnalysis {
    public static final String PLUGIN_PATH = "org.dataflowanalysis.analysis";
    private final Logger logger = Logger.getLogger(DataFlowConfidentialityAnalysis.class);

    public abstract void initializeAnalysis();

    public abstract FlowGraphCollection findFlowGraphs();

    public List<? extends AbstractVertex<?>> queryDataFlow(AbstractTransposeFlowGraph transposeFlowGraph, Predicate<? super AbstractVertex<?>> condition) {
        return transposeFlowGraph.getVertices().stream().filter(condition).toList();
    }

    public abstract void setLoggerLevel(Level var1);

    protected void setupLoggers() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ANSIConsoleLogger((Layout)new EnhancedPatternLayout("%-6r [%p] %-35C{1} - %m%n")));
        Logger.getLogger(AbstractInternalAntlrParser.class).setLevel(Level.WARN);
        Logger.getLogger(DefaultLinkingService.class).setLevel(Level.WARN);
        Logger.getLogger(ResourceSetBasedAllContainersStateProvider.class).setLevel(Level.WARN);
        Logger.getLogger(AbstractCleaningLinker.class).setLevel(Level.WARN);
        this.logger.info((Object)"Successfully initialized standalone log4j for the data flow analysis.");
    }
}

