/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataflowanalysis.analysis.core.AbstractVertex;

public abstract class AbstractTransposeFlowGraph {
    protected final AbstractVertex<?> sink;

    public AbstractTransposeFlowGraph(AbstractVertex<?> sink) {
        this.sink = sink;
    }

    public abstract AbstractTransposeFlowGraph evaluate();

    public abstract AbstractTransposeFlowGraph copy();

    public AbstractVertex<?> getSink() {
        return this.sink;
    }

    public List<? extends AbstractVertex<?>> getVertices() {
        ArrayList<AbstractVertex> vertices = new ArrayList<AbstractVertex>();
        ArrayDeque currentElements = new ArrayDeque();
        currentElements.push(this.sink);
        while (!currentElements.isEmpty()) {
            AbstractVertex currentElement = (AbstractVertex)currentElements.pop();
            if (vertices.contains(currentElement)) continue;
            vertices.add(currentElement);
            currentElement.getPreviousElements().stream().filter(Objects::nonNull).filter(it -> !vertices.contains(it)).forEach(currentElements::push);
        }
        Collections.reverse(vertices);
        return vertices;
    }

    public List<AbstractVertex<?>> getSucceedingVertices(AbstractVertex<?> vertex) {
        return this.getVertices().stream().filter(it -> it.getPreviousElements().contains(vertex)).collect(Collectors.toList());
    }

    public Stream<? extends AbstractVertex<?>> stream() {
        return this.getVertices().stream();
    }

    public String toString() {
        return this.getVertices().stream().map(AbstractVertex::toString).reduce("", (t, u) -> String.format("%s%s%s", t, System.lineSeparator(), u));
    }
}

