/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;

public abstract class AbstractVertex<T> {
    private final Logger logger = Logger.getLogger(AbstractVertex.class);
    protected final T referencedElement;
    private Optional<List<DataCharacteristic>> incomingDataCharacteristics;
    private Optional<List<DataCharacteristic>> outgoingDataCharacteristics;
    private Optional<List<CharacteristicValue>> vertexCharacteristics;

    public AbstractVertex(T referencedElement) {
        this.referencedElement = referencedElement;
        this.incomingDataCharacteristics = Optional.empty();
        this.outgoingDataCharacteristics = Optional.empty();
        this.vertexCharacteristics = Optional.empty();
    }

    public abstract void evaluateDataFlow();

    public abstract String toString();

    protected void setPropagationResult(List<DataCharacteristic> incomingDataCharacteristics, List<DataCharacteristic> outgoingDataCharacteristics, List<CharacteristicValue> vertexCharacteristics) {
        if (this.isEvaluated()) {
            this.logger.error((Object)"Cannot set propagation result of already evaluated vertex");
            throw new IllegalArgumentException();
        }
        this.incomingDataCharacteristics = Optional.of(new ArrayList<DataCharacteristic>(incomingDataCharacteristics));
        this.outgoingDataCharacteristics = Optional.of(new ArrayList<DataCharacteristic>(outgoingDataCharacteristics));
        this.vertexCharacteristics = Optional.of(new ArrayList<CharacteristicValue>(vertexCharacteristics));
    }

    public boolean isEvaluated() {
        return this.incomingDataCharacteristics.isPresent() && this.outgoingDataCharacteristics.isPresent() && this.vertexCharacteristics.isPresent();
    }

    public T getReferencedElement() {
        return this.referencedElement;
    }

    public List<DataCharacteristic> getAllDataCharacteristics() {
        return this.incomingDataCharacteristics.orElseThrow(IllegalStateException::new);
    }

    public List<DataCharacteristic> getAllIncomingDataCharacteristics() {
        return this.incomingDataCharacteristics.orElseThrow(IllegalStateException::new);
    }

    public List<DataCharacteristic> getAllOutgoingDataCharacteristics() {
        return this.outgoingDataCharacteristics.orElseThrow(IllegalStateException::new);
    }

    public List<CharacteristicValue> getAllVertexCharacteristics() {
        return this.vertexCharacteristics.orElseThrow(IllegalStateException::new);
    }

    public abstract List<? extends AbstractVertex<?>> getPreviousElements();

    public boolean isSource() {
        return this.getPreviousElements().isEmpty();
    }

    public List<CharacteristicValue> getVertexCharacteristics(String requiredCharacteristicTypeName) {
        return this.getAllVertexCharacteristics().stream().filter(cv -> cv.getTypeName().equals(requiredCharacteristicTypeName)).collect(Collectors.toList());
    }

    public List<String> getVertexCharacteristicNames(String requiredCharacteristicTypeName) {
        return this.getAllVertexCharacteristics().stream().filter(cv -> cv.getTypeName().equals(requiredCharacteristicTypeName)).map(CharacteristicValue::getValueName).collect(Collectors.toList());
    }

    public List<DataCharacteristic> getDataCharacteristics(String requiredDataCharacteristicName) {
        return this.getAllIncomingDataCharacteristics().stream().filter(it -> it.getVariableName().equals(requiredDataCharacteristicName)).collect(Collectors.toList());
    }

    public List<String> getDataCharacteristicNames(String requiredDataCharacteristicName) {
        return this.getAllIncomingDataCharacteristics().stream().filter(it -> it.getVariableName().equals(requiredDataCharacteristicName)).map(DataCharacteristic::variableName).collect(Collectors.toList());
    }

    public Map<String, List<CharacteristicValue>> getDataCharacteristicMap(String requiredCharacteristicTypeName) {
        return this.getAllIncomingDataCharacteristics().stream().collect(Collectors.toMap(DataCharacteristic::getVariableName, it -> it.getCharacteristicsWithName(requiredCharacteristicTypeName)));
    }

    public Map<String, List<String>> getDataCharacteristicNamesMap(String requiredCharacteristicTypeName) {
        return this.getAllIncomingDataCharacteristics().stream().collect(Collectors.toMap(DataCharacteristic::getVariableName, it -> it.getCharacteristicsWithName(requiredCharacteristicTypeName).stream().map(CharacteristicValue::getValueName).toList()));
    }

    public String createPrintableNodeInformation() {
        String template = "Propagated %s%s\tNode characteristics: %s%s\tData flow Variables:  %s%s";
        String nodeCharacteristics = this.createPrintableCharacteristicsList(this.getAllVertexCharacteristics());
        String dataCharacteristics = this.getAllDataCharacteristics().stream().map(e -> String.format("%s [%s]", e.variableName(), this.createPrintableCharacteristicsList(e.getAllCharacteristics()))).collect(Collectors.joining(", "));
        return String.format(template, this, System.lineSeparator(), nodeCharacteristics, System.lineSeparator(), dataCharacteristics, System.lineSeparator());
    }

    public String createPrintableCharacteristicsList(List<CharacteristicValue> characteristics) {
        List<String> entries = characteristics.stream().map(it -> String.format("%s.%s", it.getTypeName(), it.getValueName())).toList();
        return String.join((CharSequence)", ", entries);
    }
}

