/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.core;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataflowanalysis.analysis.core.CharacteristicValue;

public record DataCharacteristic(String variableName, List<CharacteristicValue> characteristics) {
    public DataCharacteristic(String variableName) {
        this(variableName, List.of());
    }

    public DataCharacteristic addCharacteristic(CharacteristicValue characteristic) {
        List<CharacteristicValue> newCharacteristics = Stream.concat(this.characteristics.stream(), Stream.of(characteristic)).toList();
        return new DataCharacteristic(this.variableName, newCharacteristics);
    }

    public boolean hasCharacteristic(CharacteristicValue characteristic) {
        return this.characteristics.contains(characteristic);
    }

    public List<CharacteristicValue> getAllCharacteristics() {
        return this.characteristics;
    }

    public List<CharacteristicValue> getCharacteristicsWithName(String characteristicType) {
        return this.characteristics().stream().filter(cv -> cv.getTypeName().equals(characteristicType)).collect(Collectors.toList());
    }

    public String getVariableName() {
        return this.variableName;
    }
}

