/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.FlowGraphCollection;
import org.dataflowanalysis.analysis.dsl.ConditionalSelectors;
import org.dataflowanalysis.analysis.dsl.DataSourceSelectors;
import org.dataflowanalysis.analysis.dsl.SourceSelectors;
import org.dataflowanalysis.analysis.dsl.VertexDestinationSelectors;
import org.dataflowanalysis.analysis.dsl.VertexSourceSelectors;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.context.DSLContextProvider;
import org.dataflowanalysis.analysis.dsl.result.DSLConstraintTrace;
import org.dataflowanalysis.analysis.dsl.result.DSLResult;
import org.dataflowanalysis.analysis.dsl.selectors.AbstractSelector;
import org.dataflowanalysis.analysis.dsl.selectors.ConditionalSelector;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class AnalysisConstraint {
    private static final String DSL_KEYWORD = "neverFlows";
    private static final String FAILED_MATCHING_MESSAGE = "Vertex %s failed to match selector %s";
    private static final String SUCEEDED_MATCHING_MESSAGE = "Vertex %s matched all selectors";
    private static final String OMMITED_TRANSPOSE_FLOW_GRAPH = "Transpose flow graph %s did not contain any violations. Omitting!";
    private final Logger logger = Logger.getLogger(AnalysisConstraint.class);
    private final DataSourceSelectors dataSourceSelectors;
    private final VertexSourceSelectors vertexSourceSelectors;
    private final VertexDestinationSelectors vertexDestinationSelectors;
    private final ConditionalSelectors conditionalSelectors;
    private final DSLContext context;

    public AnalysisConstraint() {
        this.vertexSourceSelectors = new VertexSourceSelectors();
        this.dataSourceSelectors = new DataSourceSelectors();
        this.vertexDestinationSelectors = new VertexDestinationSelectors();
        this.conditionalSelectors = new ConditionalSelectors();
        this.context = new DSLContext();
    }

    public AnalysisConstraint(VertexSourceSelectors vertexSourceSelectors, DataSourceSelectors dataSourceSelectors, VertexDestinationSelectors vertexDestinationSelectors, ConditionalSelectors conditionalSelectors, DSLContext context) {
        this.vertexSourceSelectors = vertexSourceSelectors;
        this.dataSourceSelectors = dataSourceSelectors;
        this.vertexDestinationSelectors = vertexDestinationSelectors;
        this.conditionalSelectors = conditionalSelectors;
        this.context = context;
    }

    public List<DSLResult> findViolations(FlowGraphCollection flowGraphCollection) {
        ArrayList<DSLResult> results = new ArrayList<DSLResult>();
        for (AbstractTransposeFlowGraph abstractTransposeFlowGraph : flowGraphCollection.getTransposeFlowGraphs()) {
            DSLConstraintTrace constraintTrace = new DSLConstraintTrace();
            ArrayList violations = new ArrayList();
            for (AbstractVertex<?> vertex : abstractTransposeFlowGraph.getVertices()) {
                boolean matched = true;
                for (AbstractSelector abstractSelector : Stream.concat(Stream.concat(this.dataSourceSelectors.getSelectors().stream(), this.vertexSourceSelectors.getSelectors().stream()), this.vertexDestinationSelectors.getSelectors().stream()).toList()) {
                    if (abstractSelector.matches(vertex)) continue;
                    this.logger.debug((Object)String.format(FAILED_MATCHING_MESSAGE, vertex, abstractSelector));
                    matched = false;
                    constraintTrace.addMissingSelector(vertex, abstractSelector);
                }
                for (ConditionalSelector conditionalSelector : this.conditionalSelectors.getSelectors()) {
                    if (conditionalSelector.matchesSelector(vertex, this.context)) continue;
                    this.logger.debug((Object)String.format(FAILED_MATCHING_MESSAGE, vertex, conditionalSelector));
                    matched = false;
                    constraintTrace.addMissingConditionalSelector(vertex, conditionalSelector);
                }
                if (!matched) continue;
                this.logger.debug((Object)String.format(SUCEEDED_MATCHING_MESSAGE, vertex));
                violations.add(vertex);
            }
            if (!violations.isEmpty()) {
                results.add(new DSLResult(abstractTransposeFlowGraph, violations, constraintTrace));
                continue;
            }
            this.logger.debug((Object)String.format(OMMITED_TRANSPOSE_FLOW_GRAPH, abstractTransposeFlowGraph));
        }
        return results;
    }

    public void addDataSourceSelector(AbstractSelector selector) {
        this.dataSourceSelectors.addSelector(selector);
    }

    public void addNodeSourceSelector(AbstractSelector selector) {
        this.vertexSourceSelectors.addSelector(selector);
    }

    public void addNodeDestinationSelector(AbstractSelector selector) {
        this.vertexDestinationSelectors.addSelector(selector);
    }

    public void addConditionalSelector(ConditionalSelector selector) {
        this.conditionalSelectors.addSelector(selector);
    }

    public DSLContext getContext() {
        return this.context;
    }

    public String toString() {
        StringJoiner dslString = new StringJoiner(" ");
        if (!this.dataSourceSelectors.getSelectors().isEmpty()) {
            dslString.add(this.dataSourceSelectors.toString());
        }
        if (!this.vertexSourceSelectors.getSelectors().isEmpty()) {
            dslString.add(this.vertexSourceSelectors.toString());
        }
        dslString.add(DSL_KEYWORD);
        if (!this.vertexDestinationSelectors.getSelectors().isEmpty()) {
            dslString.add(this.vertexDestinationSelectors.toString());
        }
        if (!this.conditionalSelectors.getSelectors().isEmpty()) {
            dslString.add(this.conditionalSelectors.toString());
        }
        return dslString.toString();
    }

    public static ParseResult<AnalysisConstraint> fromString(StringView string) {
        return AnalysisConstraint.fromString(string, null);
    }

    public static ParseResult<AnalysisConstraint> fromString(StringView string, DSLContextProvider contextProvider) {
        DSLContext context = new DSLContext(contextProvider);
        ParseResult<SourceSelectors> sourceSelectors = AnalysisConstraint.parseSourceSelector(string, context);
        if (sourceSelectors.failed()) {
            return ParseResult.error(sourceSelectors.getError());
        }
        DataSourceSelectors dataSourceSelectors = sourceSelectors.getResult().getDataSourceSelectors().orElse(new DataSourceSelectors());
        VertexSourceSelectors vertexSourceSelectors = sourceSelectors.getResult().getNodeSourceSelectors().orElse(new VertexSourceSelectors());
        if (!string.startsWith(DSL_KEYWORD)) {
            return string.expect(DSL_KEYWORD);
        }
        string.advance(DSL_KEYWORD.length() + 1);
        ParseResult<VertexDestinationSelectors> nodeDestinationSelectorsParseResult = VertexDestinationSelectors.fromString(string, context);
        if (nodeDestinationSelectorsParseResult.failed()) {
            return ParseResult.error(nodeDestinationSelectorsParseResult.getError());
        }
        VertexDestinationSelectors vertexDestinationSelectors = nodeDestinationSelectorsParseResult.getResult();
        ParseResult<ConditionalSelectors> conditionalSelectorsParseResult = ConditionalSelectors.fromString(string, context);
        ConditionalSelectors conditionalSelectors = conditionalSelectorsParseResult.or(new ConditionalSelectors());
        if (!string.empty()) {
            return ParseResult.error("Unexpected symbols: " + string.getString());
        }
        return ParseResult.ok(new AnalysisConstraint(vertexSourceSelectors, dataSourceSelectors, vertexDestinationSelectors, conditionalSelectors, context));
    }

    private static ParseResult<SourceSelectors> parseSourceSelector(StringView string, DSLContext context) {
        ParseResult<VertexSourceSelectors> nodeSourceSelector;
        ParseResult<DataSourceSelectors> dataSourceSelector = DataSourceSelectors.fromString(string, context);
        if (dataSourceSelector.successful()) {
            nodeSourceSelector = VertexSourceSelectors.fromString(string, context);
        } else {
            nodeSourceSelector = VertexSourceSelectors.fromString(string, context);
            if (nodeSourceSelector.successful()) {
                dataSourceSelector = DataSourceSelectors.fromString(string, context);
            }
        }
        if (nodeSourceSelector.successful() && dataSourceSelector.successful()) {
            return ParseResult.ok(new SourceSelectors(dataSourceSelector.getResult(), nodeSourceSelector.getResult()));
        }
        if (dataSourceSelector.successful()) {
            return ParseResult.ok(new SourceSelectors(dataSourceSelector.getResult()));
        }
        if (nodeSourceSelector.successful()) {
            return ParseResult.ok(new SourceSelectors(nodeSourceSelector.getResult()));
        }
        return ParseResult.error("Could not parse source selectors");
    }
}

