/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractTransposeFlowGraph;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.FlowGraphCollection;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.result.DSLConstraintTrace;
import org.dataflowanalysis.analysis.dsl.result.DSLResult;
import org.dataflowanalysis.analysis.dsl.selectors.AbstractSelector;
import org.dataflowanalysis.analysis.dsl.selectors.ConditionalSelector;

public class AnalysisQuery {
    private static final String FAILED_MATCHING_MESSAGE = "Vertex %s failed to match selector %s";
    private static final String SUCEEDED_MATCHING_MESSAGE = "Vertex %s matched all selectors";
    private static final String OMMITED_TRANSPOSE_FLOW_GRAPH = "Transpose flow graph %s did not contain any queried vertices. Omitting!";
    private final Logger logger = Logger.getLogger(AnalysisQuery.class);
    private final List<AbstractSelector> flowSource = new ArrayList<AbstractSelector>();
    private final List<ConditionalSelector> selectors = new ArrayList<ConditionalSelector>();
    private final DSLContext context = new DSLContext();

    public List<DSLResult> query(FlowGraphCollection flowGraphCollection) {
        ArrayList<DSLResult> results = new ArrayList<DSLResult>();
        for (AbstractTransposeFlowGraph abstractTransposeFlowGraph : flowGraphCollection.getTransposeFlowGraphs()) {
            DSLConstraintTrace constraintTrace = new DSLConstraintTrace();
            ArrayList matchedVertices = new ArrayList();
            for (AbstractVertex<?> vertex : abstractTransposeFlowGraph.getVertices()) {
                boolean matched = true;
                for (AbstractSelector abstractSelector : this.flowSource) {
                    if (abstractSelector.matches(vertex)) continue;
                    this.logger.debug((Object)String.format(FAILED_MATCHING_MESSAGE, vertex, abstractSelector));
                    matched = false;
                    constraintTrace.addMissingSelector(vertex, abstractSelector);
                }
                for (ConditionalSelector conditionalSelector : this.selectors) {
                    if (conditionalSelector.matchesSelector(vertex, this.context)) continue;
                    this.logger.debug((Object)String.format(FAILED_MATCHING_MESSAGE, vertex, conditionalSelector));
                    matched = false;
                    constraintTrace.addMissingConditionalSelector(vertex, conditionalSelector);
                }
                if (!matched) continue;
                this.logger.debug((Object)String.format(SUCEEDED_MATCHING_MESSAGE, vertex));
                matchedVertices.add(vertex);
            }
            if (!matchedVertices.isEmpty()) {
                results.add(new DSLResult(abstractTransposeFlowGraph, matchedVertices, constraintTrace));
                continue;
            }
            this.logger.debug((Object)String.format(OMMITED_TRANSPOSE_FLOW_GRAPH, abstractTransposeFlowGraph));
        }
        return results;
    }

    public void addFlowSource(AbstractSelector selector) {
        this.flowSource.add(selector);
    }

    public void addConditionalSelector(ConditionalSelector selector) {
        this.selectors.add(selector);
    }

    public DSLContext getContext() {
        return this.context;
    }
}

