/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.dsl.AbstractParseable;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.selectors.ConditionalSelector;
import org.dataflowanalysis.analysis.dsl.selectors.EmptySetOperationConditionalSelector;
import org.dataflowanalysis.analysis.dsl.selectors.VariableConditionalSelector;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class ConditionalSelectors
extends AbstractParseable {
    private static final String DSL_KEYWORD = "where";
    private static final Logger logger = Logger.getLogger(ConditionalSelectors.class);
    private final List<ConditionalSelector> selectors;

    public ConditionalSelectors() {
        this.selectors = new ArrayList<ConditionalSelector>();
    }

    public ConditionalSelectors(List<ConditionalSelector> selectors) {
        this.selectors = selectors;
    }

    public void addSelector(ConditionalSelector selector) {
        this.selectors.add(selector);
    }

    public List<ConditionalSelector> getSelectors() {
        return new ArrayList<ConditionalSelector>(this.selectors);
    }

    public String toString() {
        StringBuilder dslString = new StringBuilder();
        dslString.append(DSL_KEYWORD);
        dslString.append(" ");
        StringJoiner selectorString = new StringJoiner(" ");
        this.selectors.forEach(selector -> {
            StringJoiner stringJoiner2 = selectorString.add(selector.toString());
        });
        dslString.append(selectorString);
        return dslString.toString();
    }

    public static ParseResult<ConditionalSelectors> fromString(StringView string, DSLContext context) {
        if (string.invalid()) {
            return ParseResult.error("Unexpected end of input!");
        }
        if (!string.startsWith(DSL_KEYWORD)) {
            return string.expect(DSL_KEYWORD);
        }
        string.advance(DSL_KEYWORD.length() + 1);
        if (string.invalid()) {
            return ParseResult.error("Unexpected end of input!");
        }
        logger.info((Object)("Parsing: " + string.getString()));
        ArrayList<ConditionalSelector> selectors = new ArrayList<ConditionalSelector>();
        while (!string.invalid()) {
            ParseResult<VariableConditionalSelector> selector = VariableConditionalSelector.fromString(string);
            if (selector.successful()) {
                selectors.add(selector.getResult());
                continue;
            }
            ParseResult<EmptySetOperationConditionalSelector> emptySetSelector = EmptySetOperationConditionalSelector.fromString(string);
            if (emptySetSelector.successful()) {
                selectors.add(emptySetSelector.getResult());
                continue;
            }
            return ParseResult.error("Could not parse statement into conditional selector!");
        }
        if (selectors.isEmpty()) {
            string.retreat(DSL_KEYWORD.length() + 1);
            return ParseResult.error("Keyword where is missing any selectors!");
        }
        ConditionalSelectors conditionalSelectors = new ConditionalSelectors(selectors);
        return ParseResult.ok(conditionalSelectors);
    }
}

