/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.dsl.AbstractParseable;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.selectors.AbstractSelector;
import org.dataflowanalysis.analysis.dsl.selectors.DataCharacteristicListSelector;
import org.dataflowanalysis.analysis.dsl.selectors.DataCharacteristicsSelector;
import org.dataflowanalysis.analysis.dsl.selectors.VariableNameSelector;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class DataSourceSelectors
extends AbstractParseable {
    private static final Logger logger = Logger.getLogger(DataSourceSelectors.class);
    private static final String DSL_KEYWORD = "data";
    private final List<AbstractSelector> selectors;

    public DataSourceSelectors() {
        this.selectors = new ArrayList<AbstractSelector>();
    }

    public DataSourceSelectors(List<AbstractSelector> selectors) {
        this.selectors = selectors;
    }

    public void addSelector(AbstractSelector selector) {
        this.selectors.add(selector);
    }

    public List<AbstractSelector> getSelectors() {
        return new ArrayList<AbstractSelector>(this.selectors);
    }

    public String toString() {
        StringBuilder dslString = new StringBuilder();
        dslString.append(DSL_KEYWORD);
        dslString.append(" ");
        StringJoiner selectorString = new StringJoiner(" ");
        this.selectors.forEach(selector -> {
            StringJoiner stringJoiner2 = selectorString.add(selector.toString());
        });
        dslString.append(selectorString);
        return dslString.toString();
    }

    public static ParseResult<DataSourceSelectors> fromString(StringView string, DSLContext context) {
        if (string.invalid()) {
            return ParseResult.error("Unexpected end of input!");
        }
        if (!string.getString().startsWith(DSL_KEYWORD)) {
            return ParseResult.error("String did not start with data");
        }
        string.advance(DSL_KEYWORD.length() + 1);
        if (string.invalid()) {
            return ParseResult.error("Unexpected end of input!");
        }
        logger.info((Object)("Parsing: " + string.getString()));
        ArrayList<AbstractSelector> selectors = new ArrayList<AbstractSelector>();
        while (!string.invalid()) {
            ParseResult<DataCharacteristicsSelector> selector = DataCharacteristicsSelector.fromString(string, context);
            if (selector.successful()) {
                selectors.add(selector.getResult());
                continue;
            }
            ParseResult<DataCharacteristicListSelector> listSelector = DataCharacteristicListSelector.fromString(string, context);
            if (listSelector.successful()) {
                selectors.add(listSelector.getResult());
                continue;
            }
            ParseResult<VariableNameSelector> nameSelector = VariableNameSelector.fromString(string, context);
            if (!nameSelector.successful()) break;
            selectors.add(nameSelector.getResult());
        }
        if (selectors.isEmpty()) {
            return ParseResult.error("Keyword data is missing any selectors!");
        }
        DataSourceSelectors dataSourceSelectors = new DataSourceSelectors(selectors);
        return ParseResult.ok(dataSourceSelectors);
    }
}

