/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.dsl.context.DSLContextKey;
import org.dataflowanalysis.analysis.dsl.context.DSLContextProvider;
import org.dataflowanalysis.analysis.dsl.variable.ConstraintVariable;
import org.dataflowanalysis.analysis.dsl.variable.ConstraintVariableReference;

public class DSLContext {
    private final Map<DSLContextKey, List<ConstraintVariable>> context = new HashMap<DSLContextKey, List<ConstraintVariable>>();
    private final Optional<DSLContextProvider> contextProvider;

    public DSLContext() {
        this.contextProvider = Optional.empty();
    }

    public DSLContext(DSLContextProvider contextProvider) {
        this.contextProvider = Optional.ofNullable(contextProvider);
    }

    public void addMapping(DSLContextKey key, ConstraintVariable value) {
        if (this.context.containsKey(key)) {
            this.context.get(key).add(value);
        } else {
            ArrayList<ConstraintVariable> values = new ArrayList<ConstraintVariable>();
            values.add(value);
            this.context.put(key, values);
        }
    }

    public ConstraintVariable getMapping(DSLContextKey key, ConstraintVariableReference reference) {
        if (reference.name().equals("constant")) {
            return new ConstraintVariable(reference.name(), new ArrayList<String>((Collection)reference.values().get()));
        }
        if (!this.context.containsKey(key)) {
            ConstraintVariable variable = new ConstraintVariable(reference.name(), reference.values());
            this.addMapping(key, variable);
            return variable;
        }
        return this.context.get(key).stream().filter(it -> it.getName().equals(reference.name())).findFirst().orElseGet(() -> {
            ConstraintVariable variable = new ConstraintVariable(reference.name(), reference.values());
            this.addMapping(key, variable);
            return variable;
        });
    }

    public List<ConstraintVariable> getMappings(AbstractVertex<?> vertex) {
        return this.context.entrySet().stream().filter(it -> ((DSLContextKey)it.getKey()).vertex().equals(vertex)).map(Map.Entry::getValue).flatMap(Collection::stream).toList();
    }

    public Optional<DSLContextProvider> getContextProvider() {
        return this.contextProvider;
    }
}

