/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl.selectors;

import java.util.List;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.dsl.AbstractParseable;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.context.DSLContextKey;
import org.dataflowanalysis.analysis.dsl.variable.ConstraintVariable;
import org.dataflowanalysis.analysis.dsl.variable.ConstraintVariableReference;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public final class CharacteristicsSelectorData
extends AbstractParseable {
    private static final Logger logger = Logger.getLogger(CharacteristicsSelectorData.class);
    private final ConstraintVariableReference characteristicType;
    private final ConstraintVariableReference characteristicValue;

    public CharacteristicsSelectorData(ConstraintVariableReference characteristicType, ConstraintVariableReference characteristicValue) {
        this.characteristicType = characteristicType;
        this.characteristicValue = characteristicValue;
    }

    public boolean matchesCharacteristic(DSLContext context, AbstractVertex<?> vertex, CharacteristicValue characteristic, String variableName, List<String> characteristicTypes, List<String> characteristicValues) {
        ConstraintVariable characteristicTypeVariable = context.getMapping(DSLContextKey.of(variableName, vertex), this.characteristicType());
        ConstraintVariable characteristicValueVariable = context.getMapping(DSLContextKey.of(variableName, vertex), this.characteristicValue());
        if (characteristicTypeVariable.hasValues() && !characteristicTypeVariable.getPossibleValues().get().contains(characteristic.getTypeName())) {
            return false;
        }
        if (characteristicValueVariable.hasValues() && !characteristicValueVariable.getPossibleValues().get().contains(characteristic.getValueName())) {
            return false;
        }
        if (!characteristicTypeVariable.isConstant() && !characteristicTypes.contains(characteristic.getTypeName())) {
            characteristicTypes.add(characteristic.getTypeName());
        }
        if (!characteristicValueVariable.isConstant() && !characteristicValues.contains(characteristic.getValueName())) {
            characteristicValues.add(characteristic.getValueName());
        }
        return true;
    }

    public void applyResults(DSLContext context, AbstractVertex<?> vertex, String variableName, List<String> characteristicTypes, List<String> characteristicValues) {
        ConstraintVariable characteristicTypeVariable = context.getMapping(DSLContextKey.of(variableName, vertex), this.characteristicType());
        ConstraintVariable characteristicValueVariable = context.getMapping(DSLContextKey.of(variableName, vertex), this.characteristicValue());
        if (!characteristicTypeVariable.isConstant()) {
            characteristicTypeVariable.addPossibleValues(characteristicTypes);
        }
        if (!characteristicValueVariable.isConstant()) {
            characteristicValueVariable.addPossibleValues(characteristicValues);
        }
    }

    public String toString() {
        return this.characteristicType.toString() + "." + this.characteristicValue.toString();
    }

    public static ParseResult<CharacteristicsSelectorData> fromString(StringView string) {
        logger.info((Object)("Parsing: " + string.getString()));
        ParseResult<ConstraintVariableReference> characteristicType = ConstraintVariableReference.fromString(string);
        if (characteristicType.failed()) {
            return ParseResult.error(characteristicType.getError());
        }
        if (!string.startsWith(".")) {
            string.retreat(characteristicType.getResult().toString().length());
            return string.expect(".");
        }
        string.advance(".".length());
        ParseResult<ConstraintVariableReference> characteristicValue = ConstraintVariableReference.fromString(string);
        if (characteristicValue.failed()) {
            string.retreat(".".length() + characteristicType.getResult().toString().length());
            return ParseResult.error(characteristicValue.getError());
        }
        return ParseResult.ok(new CharacteristicsSelectorData(characteristicType.getResult(), characteristicValue.getResult()));
    }

    public ConstraintVariableReference characteristicType() {
        return this.characteristicType;
    }

    public ConstraintVariableReference characteristicValue() {
        return this.characteristicValue;
    }
}

