/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl.selectors;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.selectors.CharacteristicsSelectorData;
import org.dataflowanalysis.analysis.dsl.selectors.DataSelector;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class DataCharacteristicListSelector
extends DataSelector {
    private static final Logger logger = Logger.getLogger(DataCharacteristicListSelector.class);
    private final List<CharacteristicsSelectorData> dataCharacteristics;
    private final boolean inverted;

    public DataCharacteristicListSelector(DSLContext context, List<CharacteristicsSelectorData> dataCharacteristics) {
        super(context);
        this.dataCharacteristics = dataCharacteristics;
        this.inverted = false;
    }

    public DataCharacteristicListSelector(DSLContext context, List<CharacteristicsSelectorData> dataCharacteristics, boolean inverted) {
        super(context);
        this.dataCharacteristics = dataCharacteristics;
        this.inverted = inverted;
    }

    @Override
    public boolean matches(AbstractVertex<?> vertex) {
        List<String> variableNames = vertex.getAllIncomingDataCharacteristics().stream().map(DataCharacteristic::variableName).toList();
        if (variableNames.isEmpty()) {
            return false;
        }
        boolean result = true;
        for (String variableName : variableNames) {
            List presentCharacteristics = vertex.getAllIncomingDataCharacteristics().stream().filter(it -> it.variableName().equals(variableName)).flatMap(it -> it.characteristics().stream()).toList();
            ArrayList characteristicTypes = new ArrayList();
            ArrayList characteristicValues = new ArrayList();
            List<Boolean> matches = presentCharacteristics.stream().map(it -> this.dataCharacteristics.stream().anyMatch(dc -> dc.matchesCharacteristic(this.context, vertex, (CharacteristicValue)it, variableName, characteristicTypes, characteristicValues))).toList();
            this.dataCharacteristics.forEach(it -> it.applyResults(this.context, vertex, variableName, characteristicTypes, characteristicValues));
            if (!result) continue;
            boolean bl = result = this.inverted ? matches.stream().noneMatch(it -> it) : matches.stream().anyMatch(it -> it);
        }
        return result;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public String toString() {
        StringJoiner dataCharacteristicsString = new StringJoiner(",");
        this.dataCharacteristics.forEach(it -> {
            StringJoiner stringJoiner2 = dataCharacteristicsString.add(it.toString());
        });
        if (this.inverted) {
            return "!" + String.valueOf(dataCharacteristicsString);
        }
        return dataCharacteristicsString.toString();
    }

    public static ParseResult<DataCharacteristicListSelector> fromString(StringView string, DSLContext context) {
        logger.info((Object)("Parsing: " + string.getString()));
        boolean inverted = string.getString().startsWith("!");
        if (inverted) {
            string.advance("!".length());
        }
        ArrayList<CharacteristicsSelectorData> selectors = new ArrayList<CharacteristicsSelectorData>();
        ParseResult<CharacteristicsSelectorData> selectorData = CharacteristicsSelectorData.fromString(string);
        while (selectorData.successful() && !string.startsWith(" ") && !string.getString().isEmpty()) {
            selectors.add(selectorData.getResult());
            if (!string.startsWith(",")) {
                if (inverted) {
                    string.retreat("!".length());
                }
                return string.expect(",");
            }
            string.advance(",".length());
            selectorData = CharacteristicsSelectorData.fromString(string);
        }
        if (selectorData.failed()) {
            if (inverted) {
                string.retreat("!".length());
            }
            return ParseResult.error(selectorData.getError());
        }
        if (selectors.isEmpty()) {
            if (inverted) {
                string.retreat("!".length());
            }
            return ParseResult.error("Cannot parse data characteristic list selector as the list is empty!");
        }
        string.advance(1);
        return ParseResult.ok(new DataCharacteristicListSelector(context, selectors, inverted));
    }
}

