/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl.selectors;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.selectors.CharacteristicsSelectorData;
import org.dataflowanalysis.analysis.dsl.selectors.DataSelector;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class DataCharacteristicsSelector
extends DataSelector {
    private static final Logger logger = Logger.getLogger(DataCharacteristicsSelector.class);
    private final CharacteristicsSelectorData dataCharacteristic;
    private final boolean inverted;

    public DataCharacteristicsSelector(DSLContext context, CharacteristicsSelectorData dataCharacteristic) {
        super(context);
        this.dataCharacteristic = dataCharacteristic;
        this.inverted = false;
    }

    public DataCharacteristicsSelector(DSLContext context, CharacteristicsSelectorData dataCharacteristic, boolean inverted) {
        super(context);
        this.dataCharacteristic = dataCharacteristic;
        this.inverted = inverted;
    }

    @Override
    public boolean matches(AbstractVertex<?> vertex) {
        List<String> variableNames = vertex.getAllIncomingDataCharacteristics().stream().map(DataCharacteristic::variableName).toList();
        if (variableNames.isEmpty()) {
            return false;
        }
        boolean result = true;
        for (String variableName : variableNames) {
            List presentCharacteristics = vertex.getAllIncomingDataCharacteristics().stream().filter(it -> it.variableName().equals(variableName)).flatMap(it -> it.characteristics().stream()).toList();
            ArrayList<String> characteristicTypes = new ArrayList<String>();
            ArrayList<String> characteristicValues = new ArrayList<String>();
            List<Boolean> matches = presentCharacteristics.stream().map(it -> this.dataCharacteristic.matchesCharacteristic(this.context, vertex, (CharacteristicValue)it, variableName, (List<String>)characteristicTypes, (List<String>)characteristicValues)).toList();
            this.dataCharacteristic.applyResults(this.context, vertex, variableName, characteristicTypes, characteristicValues);
            if (!result) continue;
            boolean bl = result = this.inverted ? matches.stream().noneMatch(it -> it) : matches.stream().anyMatch(it -> it);
        }
        return result;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public String toString() {
        if (this.inverted) {
            return "!" + this.dataCharacteristic.toString();
        }
        return this.dataCharacteristic.toString();
    }

    public static ParseResult<DataCharacteristicsSelector> fromString(StringView string, DSLContext context) {
        ParseResult<CharacteristicsSelectorData> selectorData;
        logger.info((Object)("Parsing: " + string.getString()));
        boolean inverted = string.getString().startsWith("!");
        if (inverted) {
            string.advance("!".length());
        }
        if ((selectorData = CharacteristicsSelectorData.fromString(string)).failed()) {
            if (inverted) {
                string.retreat("!".length());
            }
            return ParseResult.error(selectorData.getError());
        }
        string.advance(1);
        return ParseResult.ok(new DataCharacteristicsSelector(context, selectorData.getResult(), inverted));
    }
}

