/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl.selectors;

import java.util.List;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.dsl.AbstractParseable;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.context.DSLContextKey;
import org.dataflowanalysis.analysis.dsl.selectors.SetOperation;
import org.dataflowanalysis.analysis.dsl.variable.ConstraintVariable;
import org.dataflowanalysis.analysis.dsl.variable.ConstraintVariableReference;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class Intersection
extends AbstractParseable
implements SetOperation {
    private static final String DSL_KEYWORD = "intersection";
    private static final Logger logger = Logger.getLogger(Intersection.class);
    private final ConstraintVariableReference firstVariable;
    private final ConstraintVariableReference secondVariable;

    public Intersection(ConstraintVariableReference firstVariable, ConstraintVariableReference secondVariable) {
        this.firstVariable = firstVariable;
        this.secondVariable = secondVariable;
    }

    public static Intersection of(ConstraintVariableReference firstVariable, ConstraintVariableReference secondVariable) {
        return new Intersection(firstVariable, secondVariable);
    }

    @Override
    public List<String> match(AbstractVertex<?> vertex, String variableName, DSLContext context) {
        ConstraintVariable first = context.getMapping(DSLContextKey.of(variableName, vertex), this.firstVariable);
        ConstraintVariable second = context.getMapping(DSLContextKey.of(variableName, vertex), this.secondVariable);
        if (!first.hasValues() || !second.hasValues()) {
            return List.of();
        }
        return first.getPossibleValues().get().stream().distinct().filter(it -> second.getPossibleValues().get().contains(it)).toList();
    }

    public ConstraintVariableReference getFirstVariable() {
        return this.firstVariable;
    }

    public ConstraintVariableReference getSecondVariable() {
        return this.secondVariable;
    }

    public String toString() {
        return "intersection(" + this.firstVariable.toString() + "," + this.secondVariable.toString() + ")";
    }

    public static ParseResult<Intersection> fromString(StringView string) {
        logger.info((Object)("Parsing: " + string.getString()));
        if (!string.startsWith(DSL_KEYWORD)) {
            return string.expect(DSL_KEYWORD);
        }
        string.advance(DSL_KEYWORD.length());
        if (!string.startsWith("(")) {
            string.retreat(DSL_KEYWORD.length());
            return string.expect("(");
        }
        string.advance("(".length());
        ParseResult<ConstraintVariableReference> firstConstraintVariableReference = ConstraintVariableReference.fromString(string);
        if (firstConstraintVariableReference.failed()) {
            string.retreat(DSL_KEYWORD.length() + "(".length());
            return ParseResult.error(firstConstraintVariableReference.getError());
        }
        if (!string.startsWith(",")) {
            string.retreat(DSL_KEYWORD.length() + "(".length() + firstConstraintVariableReference.getResult().toString().length());
            return string.expect(",");
        }
        string.advance(",".length());
        ParseResult<ConstraintVariableReference> secondConstraintVariableReference = ConstraintVariableReference.fromString(string);
        if (secondConstraintVariableReference.failed()) {
            string.retreat(DSL_KEYWORD.length() + "(".length() + firstConstraintVariableReference.getResult().toString().length() + ",".length());
            return ParseResult.error(secondConstraintVariableReference.getError());
        }
        if (!string.startsWith(")")) {
            string.retreat(DSL_KEYWORD.length() + "(".length() + firstConstraintVariableReference.getResult().toString().length() + ",".length() + secondConstraintVariableReference.getResult().toString().length());
            return string.expect(")");
        }
        string.advance(")".length());
        return ParseResult.ok(new Intersection(firstConstraintVariableReference.getResult(), secondConstraintVariableReference.getResult()));
    }
}

