/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl.selectors;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.core.AbstractVertex;
import org.dataflowanalysis.analysis.core.CharacteristicValue;
import org.dataflowanalysis.analysis.core.DataCharacteristic;
import org.dataflowanalysis.analysis.dsl.context.DSLContext;
import org.dataflowanalysis.analysis.dsl.selectors.CharacteristicsSelectorData;
import org.dataflowanalysis.analysis.dsl.selectors.DataSelector;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public class VertexCharacteristicsSelector
extends DataSelector {
    private static final Logger logger = Logger.getLogger(VertexCharacteristicsSelector.class);
    private final CharacteristicsSelectorData vertexCharacteristics;
    private final boolean inverted;
    private final boolean recursive;

    public VertexCharacteristicsSelector(DSLContext context, CharacteristicsSelectorData vertexCharacteristics) {
        super(context);
        this.vertexCharacteristics = vertexCharacteristics;
        this.inverted = false;
        this.recursive = false;
    }

    public VertexCharacteristicsSelector(DSLContext context, CharacteristicsSelectorData vertexCharacteristics, boolean inverted) {
        super(context);
        this.vertexCharacteristics = vertexCharacteristics;
        this.inverted = inverted;
        this.recursive = false;
    }

    public VertexCharacteristicsSelector(DSLContext context, CharacteristicsSelectorData vertexCharacteristics, boolean inverted, boolean recursive) {
        super(context);
        this.vertexCharacteristics = vertexCharacteristics;
        this.inverted = inverted;
        this.recursive = recursive;
    }

    @Override
    public boolean matches(AbstractVertex<?> vertex) {
        List<String> variableNames = vertex.getAllIncomingDataCharacteristics().stream().map(DataCharacteristic::variableName).toList();
        boolean result = !variableNames.isEmpty();
        for (String variableName : variableNames) {
            List<CharacteristicValue> presentCharacteristics = vertex.getAllVertexCharacteristics();
            ArrayList<String> characteristicTypes = new ArrayList<String>();
            ArrayList<String> characteristicValues = new ArrayList<String>();
            List<Boolean> matches = presentCharacteristics.stream().map(it -> this.vertexCharacteristics.matchesCharacteristic(this.context, vertex, (CharacteristicValue)it, variableName, (List<String>)characteristicTypes, (List<String>)characteristicValues)).toList();
            this.vertexCharacteristics.applyResults(this.context, vertex, variableName, characteristicTypes, characteristicValues);
            if (!result) continue;
            boolean bl = result = this.inverted ? matches.stream().noneMatch(it -> it) : matches.stream().anyMatch(it -> it);
        }
        if (this.recursive) {
            return result || vertex.getPreviousElements().stream().anyMatch(this::matches);
        }
        return result;
    }

    public String toString() {
        if (this.inverted) {
            return "!" + this.vertexCharacteristics.toString();
        }
        return this.vertexCharacteristics.toString();
    }

    public static ParseResult<VertexCharacteristicsSelector> fromString(StringView string, DSLContext context) {
        ParseResult<CharacteristicsSelectorData> selectorData;
        logger.info((Object)("Parsing: " + string.getString()));
        boolean inverted = string.getString().startsWith("!");
        if (inverted) {
            string.advance("!".length());
        }
        if ((selectorData = CharacteristicsSelectorData.fromString(string)).failed()) {
            if (inverted) {
                string.retreat("!".length());
            }
            return ParseResult.error(selectorData.getError());
        }
        string.advance(1);
        return ParseResult.ok(new VertexCharacteristicsSelector(context, selectorData.getResult(), inverted));
    }

    public boolean isInverted() {
        return this.inverted;
    }
}

