/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.dsl.variable;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.dataflowanalysis.analysis.dsl.AbstractParseable;
import org.dataflowanalysis.analysis.utils.ParseResult;
import org.dataflowanalysis.analysis.utils.StringView;

public final class ConstraintVariableReference
extends AbstractParseable {
    private static final String DSL_VARIABLE_SIGN = "$";
    private static final Logger logger = Logger.getLogger(ConstraintVariableReference.class);
    private final String name;
    private final Optional<List<String>> values;

    public ConstraintVariableReference(String name, Optional<List<String>> values) {
        this.name = name;
        this.values = values;
    }

    public static ConstraintVariableReference of(String name) {
        return new ConstraintVariableReference(name, Optional.empty());
    }

    public static ConstraintVariableReference of(String name, List<String> values) {
        return new ConstraintVariableReference(name, Optional.of(values));
    }

    public static ConstraintVariableReference ofConstant(List<String> values) {
        return new ConstraintVariableReference("constant", Optional.of(values));
    }

    public boolean isConstant() {
        return this.name.equals("constant");
    }

    public String toString() {
        if (this.isConstant() && this.values.isPresent()) {
            return this.values.get().get(0);
        }
        return DSL_VARIABLE_SIGN + this.name;
    }

    public static ParseResult<ConstraintVariableReference> fromString(StringView stringView) {
        if (stringView.invalid() || stringView.empty()) {
            return ParseResult.error("Cannot create variable: Expected any string!");
        }
        String[] split = stringView.getString().split("[ .,()]");
        if (split.length == 0) {
            return ParseResult.error("Invalid variable: Expected any string!");
        }
        String string = split[0];
        logger.info((Object)("Parsing: " + string));
        stringView.advance(string.length());
        if (string.startsWith(DSL_VARIABLE_SIGN)) {
            if (string.substring(1).isEmpty()) {
                return ParseResult.error("Empty variable name!");
            }
            return ParseResult.ok(ConstraintVariableReference.of(string.substring(1)));
        }
        if (string.isEmpty()) {
            return ParseResult.error("Constant must be not be empty!");
        }
        if (string.contains("!")) {
            return ParseResult.error("Constants must not contain \"!\" in their name!");
        }
        return ParseResult.ok(ConstraintVariableReference.ofConstant(List.of(string)));
    }

    public String name() {
        return this.name;
    }

    public Optional<List<String>> values() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConstraintVariableReference that = (ConstraintVariableReference)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }
}

