/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.resource;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.core.entity.Entity;

public abstract class ResourceProvider {
    private static final Logger logger = Logger.getLogger(ResourceProvider.class);
    protected final ResourceSet resources = new ResourceSetImpl();

    public abstract void loadRequiredResources();

    public abstract boolean sufficientResourcesLoaded();

    public abstract void setupResources();

    public void validate() {
        for (Resource resource : this.resources.getResources()) {
            if (resource.getErrors().isEmpty()) continue;
            logger.error((Object)("Error loading model " + resource.getURI().toString()));
            resource.getErrors().forEach(error -> logger.error((Object)error.getMessage()));
        }
    }

    public Optional<EObject> lookupElementWithId(String id) {
        for (Resource resource : this.getResources()) {
            Optional<EObject> result = this.findInResource(it -> {
                if (it instanceof Entity) {
                    return ((Entity)it).getId().equals(id);
                }
                return false;
            }, resource);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Optional<EObject> lookupElementWithCondition(Predicate<EObject> condition) {
        for (Resource resource : this.getResources()) {
            Optional<EObject> result = this.findInResource(condition, resource);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public <T extends EObject> List<T> lookupToplevelElement(EClass targetType) {
        ArrayList result = new ArrayList();
        for (Resource resource : this.resources.getResources()) {
            if (!this.isTargetInResource(targetType, resource)) continue;
            result.addAll(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)targetType));
        }
        return result;
    }

    protected EObject loadModelContent(URI modelURI) {
        Resource resource = this.resources.getResource(modelURI, true);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Model with URI %s could not be loaded", modelURI));
        }
        if (resource.getContents().isEmpty()) {
            throw new IllegalArgumentException(String.format("Model with URI %s is empty", modelURI));
        }
        if (!resource.getErrors().isEmpty()) {
            logger.error((Object)("Error loading resource: " + String.valueOf(resource.getErrors())));
        }
        if (!resource.getErrors().isEmpty()) {
            logger.error((Object)"Errors occurred during loading a model:");
            logger.error(resource.getErrors().stream().map(Resource.Diagnostic::getMessage).toList());
        }
        return (EObject)resource.getContents().get(0);
    }

    private Optional<EObject> findInResource(Predicate<EObject> condition, Resource resource) {
        if (resource == null) {
            return Optional.empty();
        }
        HashMap<EObject, Boolean> visitedNodes = new HashMap<EObject, Boolean>();
        ArrayDeque<EObject> stack = new ArrayDeque<EObject>((Collection<EObject>)resource.getContents());
        while (!stack.isEmpty()) {
            EObject top = (EObject)stack.pop();
            stack.addAll(top.eContents().stream().filter(it -> !visitedNodes.containsKey(it) || (Boolean)visitedNodes.get(it) == false).toList());
            if (visitedNodes.containsKey(top) && ((Boolean)visitedNodes.get(top)).booleanValue()) continue;
            if (condition.test(top)) {
                return Optional.of(top);
            }
            visitedNodes.put(top, true);
        }
        return Optional.empty();
    }

    public boolean isTargetInResource(EClass targetType, Resource resource) {
        if (resource != null) {
            for (EObject c : resource.getContents()) {
                if (!targetType.isSuperTypeOf(c.eClass())) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Resource> getResources() {
        return new ArrayList<Resource>((Collection<Resource>)this.resources.getResources());
    }
}

