/*
 * Decompiled with CFR 0.152.
 */
package org.dataflowanalysis.analysis.utils;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class ANSIConsoleLogger
extends ConsoleAppender {
    private static final int NORMAL = 0;
    private static final int BRIGHT = 1;
    private static final int FOREGROUND_RED = 31;
    private static final int FOREGROUND_YELLOW = 33;
    private static final int FOREGROUND_BLUE = 34;
    private static final int FOREGROUND_CYAN = 36;
    private static final String PREFIX = "\u001b[";
    private static final String SUFFIX = "m";
    private static final char SEPARATOR = ';';
    private static final String END_COLOR = "\u001b[m";
    private static final String FATAL_COLOR = "\u001b[1;31m";
    private static final String ERROR_COLOR = "\u001b[0;31m";
    private static final String WARN_COLOR = "\u001b[0;33m";
    private static final String INFO_COLOR = "\u001b[m";
    private static final String DEBUG_COLOR = "\u001b[0;36m";
    private static final String TRACE_COLOR = "\u001b[0;34m";

    public ANSIConsoleLogger(Layout layout) {
        super(layout);
    }

    protected void subAppend(LoggingEvent event) {
        this.qw.write(this.getColor(event.getLevel()));
        super.subAppend(event);
        this.qw.write("\u001b[m");
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }

    private String getColor(Level level) {
        switch (level.toInt()) {
            case 50000: {
                return FATAL_COLOR;
            }
            case 40000: {
                return ERROR_COLOR;
            }
            case 30000: {
                return WARN_COLOR;
            }
            case 20000: {
                return "\u001b[m";
            }
            case 10000: {
                return DEBUG_COLOR;
            }
        }
        return TRACE_COLOR;
    }
}

