/**
 */
package org.dataflowanalysis.dfd.datadictionary;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import tools.mdsd.modelingfoundations.identifier.IdentifierPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.dataflowanalysis.dfd.datadictionary.datadictionaryFactory
 * @model kind="package"
 * @generated
 */
public interface datadictionaryPackage extends EPackage
{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "datadictionary";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://dataflowanalysis.org/dfd/datadictionary";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "datadictionary";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	datadictionaryPackage eINSTANCE = org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.DataDictionaryImpl <em>Data Dictionary</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.DataDictionaryImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getDataDictionary()
	 * @generated
	 */
	int DATA_DICTIONARY = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DICTIONARY__ID = IdentifierPackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DICTIONARY__ENTITY_NAME = IdentifierPackage.ENTITY__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Label Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DICTIONARY__LABEL_TYPES = IdentifierPackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Behavior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DICTIONARY__BEHAVIOR = IdentifierPackage.ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Dictionary</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DICTIONARY_FEATURE_COUNT = IdentifierPackage.ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Data Dictionary</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_DICTIONARY_OPERATION_COUNT = IdentifierPackage.ENTITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.BehaviorImpl <em>Behavior</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.BehaviorImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getBehavior()
	 * @generated
	 */
	int BEHAVIOR = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR__ID = IdentifierPackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR__ENTITY_NAME = IdentifierPackage.ENTITY__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>In Pin</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR__IN_PIN = IdentifierPackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Out Pin</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR__OUT_PIN = IdentifierPackage.ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Assignment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR__ASSIGNMENT = IdentifierPackage.ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Behavior</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_FEATURE_COUNT = IdentifierPackage.ENTITY_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Behavior</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_OPERATION_COUNT = IdentifierPackage.ENTITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.PinImpl <em>Pin</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.PinImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getPin()
	 * @generated
	 */
	int PIN = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PIN__ID = IdentifierPackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PIN__ENTITY_NAME = IdentifierPackage.ENTITY__ENTITY_NAME;

	/**
	 * The number of structural features of the '<em>Pin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PIN_FEATURE_COUNT = IdentifierPackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Pin</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PIN_OPERATION_COUNT = IdentifierPackage.ENTITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.AbstractAssignmentImpl <em>Abstract Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.AbstractAssignmentImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getAbstractAssignment()
	 * @generated
	 */
	int ABSTRACT_ASSIGNMENT = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ASSIGNMENT__ID = IdentifierPackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ASSIGNMENT__ENTITY_NAME = IdentifierPackage.ENTITY__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Output Pin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ASSIGNMENT__OUTPUT_PIN = IdentifierPackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ASSIGNMENT_FEATURE_COUNT = IdentifierPackage.ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_ASSIGNMENT_OPERATION_COUNT = IdentifierPackage.ENTITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.AssignmentImpl <em>Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.AssignmentImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getAssignment()
	 * @generated
	 */
	int ASSIGNMENT = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__ID = ABSTRACT_ASSIGNMENT__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__ENTITY_NAME = ABSTRACT_ASSIGNMENT__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Output Pin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__OUTPUT_PIN = ABSTRACT_ASSIGNMENT__OUTPUT_PIN;

	/**
	 * The feature id for the '<em><b>Term</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__TERM = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Output Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__OUTPUT_LABELS = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Input Pins</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT__INPUT_PINS = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_FEATURE_COUNT = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSIGNMENT_OPERATION_COUNT = ABSTRACT_ASSIGNMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.ForwardingAssignmentImpl <em>Forwarding Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.ForwardingAssignmentImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getForwardingAssignment()
	 * @generated
	 */
	int FORWARDING_ASSIGNMENT = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORWARDING_ASSIGNMENT__ID = ABSTRACT_ASSIGNMENT__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORWARDING_ASSIGNMENT__ENTITY_NAME = ABSTRACT_ASSIGNMENT__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Output Pin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORWARDING_ASSIGNMENT__OUTPUT_PIN = ABSTRACT_ASSIGNMENT__OUTPUT_PIN;

	/**
	 * The feature id for the '<em><b>Input Pins</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORWARDING_ASSIGNMENT__INPUT_PINS = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Forwarding Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORWARDING_ASSIGNMENT_FEATURE_COUNT = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Forwarding Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORWARDING_ASSIGNMENT_OPERATION_COUNT = ABSTRACT_ASSIGNMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.LabelImpl <em>Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.LabelImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getLabel()
	 * @generated
	 */
	int LABEL = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__ID = IdentifierPackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL__ENTITY_NAME = IdentifierPackage.ENTITY__ENTITY_NAME;

	/**
	 * The number of structural features of the '<em>Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_FEATURE_COUNT = IdentifierPackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_OPERATION_COUNT = IdentifierPackage.ENTITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.LabelTypeImpl <em>Label Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.LabelTypeImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getLabelType()
	 * @generated
	 */
	int LABEL_TYPE = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_TYPE__ID = IdentifierPackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_TYPE__ENTITY_NAME = IdentifierPackage.ENTITY__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_TYPE__LABEL = IdentifierPackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Label Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_TYPE_FEATURE_COUNT = IdentifierPackage.ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Label Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_TYPE_OPERATION_COUNT = IdentifierPackage.ENTITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.TermImpl <em>Term</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.TermImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getTerm()
	 * @generated
	 */
	int TERM = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM__ID = IdentifierPackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM__ENTITY_NAME = IdentifierPackage.ENTITY__ENTITY_NAME;

	/**
	 * The number of structural features of the '<em>Term</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_FEATURE_COUNT = IdentifierPackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Term</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TERM_OPERATION_COUNT = IdentifierPackage.ENTITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.TRUEImpl <em>TRUE</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.TRUEImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getTRUE()
	 * @generated
	 */
	int TRUE = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUE__ID = TERM__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUE__ENTITY_NAME = TERM__ENTITY_NAME;

	/**
	 * The number of structural features of the '<em>TRUE</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUE_FEATURE_COUNT = TERM_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>TRUE</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRUE_OPERATION_COUNT = TERM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.BinaryOperatorImpl <em>Binary Operator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.BinaryOperatorImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getBinaryOperator()
	 * @generated
	 */
	int BINARY_OPERATOR = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATOR__ID = TERM__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATOR__ENTITY_NAME = TERM__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATOR__TERMS = TERM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Binary Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATOR_FEATURE_COUNT = TERM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Binary Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_OPERATOR_OPERATION_COUNT = TERM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.ANDImpl <em>AND</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.ANDImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getAND()
	 * @generated
	 */
	int AND = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND__ID = BINARY_OPERATOR__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND__ENTITY_NAME = BINARY_OPERATOR__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND__TERMS = BINARY_OPERATOR__TERMS;

	/**
	 * The number of structural features of the '<em>AND</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND_FEATURE_COUNT = BINARY_OPERATOR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>AND</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AND_OPERATION_COUNT = BINARY_OPERATOR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.ORImpl <em>OR</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.ORImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getOR()
	 * @generated
	 */
	int OR = 12;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR__ID = BINARY_OPERATOR__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR__ENTITY_NAME = BINARY_OPERATOR__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR__TERMS = BINARY_OPERATOR__TERMS;

	/**
	 * The number of structural features of the '<em>OR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR_FEATURE_COUNT = BINARY_OPERATOR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>OR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OR_OPERATION_COUNT = BINARY_OPERATOR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.NOTImpl <em>NOT</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.NOTImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getNOT()
	 * @generated
	 */
	int NOT = 13;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT__ID = TERM__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT__ENTITY_NAME = TERM__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Negated Term</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT__NEGATED_TERM = TERM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>NOT</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_FEATURE_COUNT = TERM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>NOT</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOT_OPERATION_COUNT = TERM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.LabelReferenceImpl <em>Label Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.LabelReferenceImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getLabelReference()
	 * @generated
	 */
	int LABEL_REFERENCE = 14;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_REFERENCE__ID = TERM__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_REFERENCE__ENTITY_NAME = TERM__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Label</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_REFERENCE__LABEL = TERM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Label Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_REFERENCE_FEATURE_COUNT = TERM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Label Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LABEL_REFERENCE_OPERATION_COUNT = TERM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.SetAssignmentImpl <em>Set Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.SetAssignmentImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getSetAssignment()
	 * @generated
	 */
	int SET_ASSIGNMENT = 15;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_ASSIGNMENT__ID = ABSTRACT_ASSIGNMENT__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_ASSIGNMENT__ENTITY_NAME = ABSTRACT_ASSIGNMENT__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Output Pin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_ASSIGNMENT__OUTPUT_PIN = ABSTRACT_ASSIGNMENT__OUTPUT_PIN;

	/**
	 * The feature id for the '<em><b>Output Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_ASSIGNMENT__OUTPUT_LABELS = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Set Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_ASSIGNMENT_FEATURE_COUNT = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Set Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SET_ASSIGNMENT_OPERATION_COUNT = ABSTRACT_ASSIGNMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.UnsetAssignmentImpl <em>Unset Assignment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.UnsetAssignmentImpl
	 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getUnsetAssignment()
	 * @generated
	 */
	int UNSET_ASSIGNMENT = 16;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSET_ASSIGNMENT__ID = ABSTRACT_ASSIGNMENT__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSET_ASSIGNMENT__ENTITY_NAME = ABSTRACT_ASSIGNMENT__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Output Pin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSET_ASSIGNMENT__OUTPUT_PIN = ABSTRACT_ASSIGNMENT__OUTPUT_PIN;

	/**
	 * The feature id for the '<em><b>Output Labels</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSET_ASSIGNMENT__OUTPUT_LABELS = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Unset Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSET_ASSIGNMENT_FEATURE_COUNT = ABSTRACT_ASSIGNMENT_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Unset Assignment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSET_ASSIGNMENT_OPERATION_COUNT = ABSTRACT_ASSIGNMENT_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.DataDictionary <em>Data Dictionary</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Dictionary</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.DataDictionary
	 * @generated
	 */
	EClass getDataDictionary();

	/**
	 * Returns the meta object for the containment reference list '{@link org.dataflowanalysis.dfd.datadictionary.DataDictionary#getLabelTypes <em>Label Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Label Types</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.DataDictionary#getLabelTypes()
	 * @see #getDataDictionary()
	 * @generated
	 */
	EReference getDataDictionary_LabelTypes();

	/**
	 * Returns the meta object for the containment reference list '{@link org.dataflowanalysis.dfd.datadictionary.DataDictionary#getBehavior <em>Behavior</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Behavior</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.DataDictionary#getBehavior()
	 * @see #getDataDictionary()
	 * @generated
	 */
	EReference getDataDictionary_Behavior();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.Behavior <em>Behavior</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Behavior</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Behavior
	 * @generated
	 */
	EClass getBehavior();

	/**
	 * Returns the meta object for the containment reference list '{@link org.dataflowanalysis.dfd.datadictionary.Behavior#getInPin <em>In Pin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>In Pin</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Behavior#getInPin()
	 * @see #getBehavior()
	 * @generated
	 */
	EReference getBehavior_InPin();

	/**
	 * Returns the meta object for the containment reference list '{@link org.dataflowanalysis.dfd.datadictionary.Behavior#getOutPin <em>Out Pin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Out Pin</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Behavior#getOutPin()
	 * @see #getBehavior()
	 * @generated
	 */
	EReference getBehavior_OutPin();

	/**
	 * Returns the meta object for the containment reference list '{@link org.dataflowanalysis.dfd.datadictionary.Behavior#getAssignment <em>Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Assignment</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Behavior#getAssignment()
	 * @see #getBehavior()
	 * @generated
	 */
	EReference getBehavior_Assignment();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.Pin <em>Pin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pin</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Pin
	 * @generated
	 */
	EClass getPin();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.AbstractAssignment <em>Abstract Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Assignment</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.AbstractAssignment
	 * @generated
	 */
	EClass getAbstractAssignment();

	/**
	 * Returns the meta object for the reference '{@link org.dataflowanalysis.dfd.datadictionary.AbstractAssignment#getOutputPin <em>Output Pin</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Output Pin</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.AbstractAssignment#getOutputPin()
	 * @see #getAbstractAssignment()
	 * @generated
	 */
	EReference getAbstractAssignment_OutputPin();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.Assignment <em>Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assignment</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Assignment
	 * @generated
	 */
	EClass getAssignment();

	/**
	 * Returns the meta object for the containment reference '{@link org.dataflowanalysis.dfd.datadictionary.Assignment#getTerm <em>Term</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Term</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Assignment#getTerm()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_Term();

	/**
	 * Returns the meta object for the reference list '{@link org.dataflowanalysis.dfd.datadictionary.Assignment#getOutputLabels <em>Output Labels</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Output Labels</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Assignment#getOutputLabels()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_OutputLabels();

	/**
	 * Returns the meta object for the reference list '{@link org.dataflowanalysis.dfd.datadictionary.Assignment#getInputPins <em>Input Pins</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Input Pins</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Assignment#getInputPins()
	 * @see #getAssignment()
	 * @generated
	 */
	EReference getAssignment_InputPins();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment <em>Forwarding Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Forwarding Assignment</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment
	 * @generated
	 */
	EClass getForwardingAssignment();

	/**
	 * Returns the meta object for the reference list '{@link org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment#getInputPins <em>Input Pins</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Input Pins</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.ForwardingAssignment#getInputPins()
	 * @see #getForwardingAssignment()
	 * @generated
	 */
	EReference getForwardingAssignment_InputPins();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.Label <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Label</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Label
	 * @generated
	 */
	EClass getLabel();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.LabelType <em>Label Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Label Type</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.LabelType
	 * @generated
	 */
	EClass getLabelType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.dataflowanalysis.dfd.datadictionary.LabelType#getLabel <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Label</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.LabelType#getLabel()
	 * @see #getLabelType()
	 * @generated
	 */
	EReference getLabelType_Label();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.Term <em>Term</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Term</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.Term
	 * @generated
	 */
	EClass getTerm();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.TRUE <em>TRUE</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRUE</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.TRUE
	 * @generated
	 */
	EClass getTRUE();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.BinaryOperator <em>Binary Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Binary Operator</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.BinaryOperator
	 * @generated
	 */
	EClass getBinaryOperator();

	/**
	 * Returns the meta object for the containment reference list '{@link org.dataflowanalysis.dfd.datadictionary.BinaryOperator#getTerms <em>Terms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Terms</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.BinaryOperator#getTerms()
	 * @see #getBinaryOperator()
	 * @generated
	 */
	EReference getBinaryOperator_Terms();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.AND <em>AND</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>AND</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.AND
	 * @generated
	 */
	EClass getAND();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.OR <em>OR</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>OR</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.OR
	 * @generated
	 */
	EClass getOR();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.NOT <em>NOT</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>NOT</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.NOT
	 * @generated
	 */
	EClass getNOT();

	/**
	 * Returns the meta object for the containment reference '{@link org.dataflowanalysis.dfd.datadictionary.NOT#getNegatedTerm <em>Negated Term</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Negated Term</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.NOT#getNegatedTerm()
	 * @see #getNOT()
	 * @generated
	 */
	EReference getNOT_NegatedTerm();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.LabelReference <em>Label Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Label Reference</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.LabelReference
	 * @generated
	 */
	EClass getLabelReference();

	/**
	 * Returns the meta object for the reference '{@link org.dataflowanalysis.dfd.datadictionary.LabelReference#getLabel <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Label</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.LabelReference#getLabel()
	 * @see #getLabelReference()
	 * @generated
	 */
	EReference getLabelReference_Label();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.SetAssignment <em>Set Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Set Assignment</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.SetAssignment
	 * @generated
	 */
	EClass getSetAssignment();

	/**
	 * Returns the meta object for the reference list '{@link org.dataflowanalysis.dfd.datadictionary.SetAssignment#getOutputLabels <em>Output Labels</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Output Labels</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.SetAssignment#getOutputLabels()
	 * @see #getSetAssignment()
	 * @generated
	 */
	EReference getSetAssignment_OutputLabels();

	/**
	 * Returns the meta object for class '{@link org.dataflowanalysis.dfd.datadictionary.UnsetAssignment <em>Unset Assignment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unset Assignment</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.UnsetAssignment
	 * @generated
	 */
	EClass getUnsetAssignment();

	/**
	 * Returns the meta object for the reference list '{@link org.dataflowanalysis.dfd.datadictionary.UnsetAssignment#getOutputLabels <em>Output Labels</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Output Labels</em>'.
	 * @see org.dataflowanalysis.dfd.datadictionary.UnsetAssignment#getOutputLabels()
	 * @see #getUnsetAssignment()
	 * @generated
	 */
	EReference getUnsetAssignment_OutputLabels();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	datadictionaryFactory getdatadictionaryFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals
	{
		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.DataDictionaryImpl <em>Data Dictionary</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.DataDictionaryImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getDataDictionary()
		 * @generated
		 */
		EClass DATA_DICTIONARY = eINSTANCE.getDataDictionary();

		/**
		 * The meta object literal for the '<em><b>Label Types</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_DICTIONARY__LABEL_TYPES = eINSTANCE.getDataDictionary_LabelTypes();

		/**
		 * The meta object literal for the '<em><b>Behavior</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_DICTIONARY__BEHAVIOR = eINSTANCE.getDataDictionary_Behavior();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.BehaviorImpl <em>Behavior</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.BehaviorImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getBehavior()
		 * @generated
		 */
		EClass BEHAVIOR = eINSTANCE.getBehavior();

		/**
		 * The meta object literal for the '<em><b>In Pin</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BEHAVIOR__IN_PIN = eINSTANCE.getBehavior_InPin();

		/**
		 * The meta object literal for the '<em><b>Out Pin</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BEHAVIOR__OUT_PIN = eINSTANCE.getBehavior_OutPin();

		/**
		 * The meta object literal for the '<em><b>Assignment</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BEHAVIOR__ASSIGNMENT = eINSTANCE.getBehavior_Assignment();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.PinImpl <em>Pin</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.PinImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getPin()
		 * @generated
		 */
		EClass PIN = eINSTANCE.getPin();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.AbstractAssignmentImpl <em>Abstract Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.AbstractAssignmentImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getAbstractAssignment()
		 * @generated
		 */
		EClass ABSTRACT_ASSIGNMENT = eINSTANCE.getAbstractAssignment();

		/**
		 * The meta object literal for the '<em><b>Output Pin</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_ASSIGNMENT__OUTPUT_PIN = eINSTANCE.getAbstractAssignment_OutputPin();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.AssignmentImpl <em>Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.AssignmentImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getAssignment()
		 * @generated
		 */
		EClass ASSIGNMENT = eINSTANCE.getAssignment();

		/**
		 * The meta object literal for the '<em><b>Term</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT__TERM = eINSTANCE.getAssignment_Term();

		/**
		 * The meta object literal for the '<em><b>Output Labels</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT__OUTPUT_LABELS = eINSTANCE.getAssignment_OutputLabels();

		/**
		 * The meta object literal for the '<em><b>Input Pins</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSIGNMENT__INPUT_PINS = eINSTANCE.getAssignment_InputPins();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.ForwardingAssignmentImpl <em>Forwarding Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.ForwardingAssignmentImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getForwardingAssignment()
		 * @generated
		 */
		EClass FORWARDING_ASSIGNMENT = eINSTANCE.getForwardingAssignment();

		/**
		 * The meta object literal for the '<em><b>Input Pins</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FORWARDING_ASSIGNMENT__INPUT_PINS = eINSTANCE.getForwardingAssignment_InputPins();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.LabelImpl <em>Label</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.LabelImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getLabel()
		 * @generated
		 */
		EClass LABEL = eINSTANCE.getLabel();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.LabelTypeImpl <em>Label Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.LabelTypeImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getLabelType()
		 * @generated
		 */
		EClass LABEL_TYPE = eINSTANCE.getLabelType();

		/**
		 * The meta object literal for the '<em><b>Label</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LABEL_TYPE__LABEL = eINSTANCE.getLabelType_Label();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.TermImpl <em>Term</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.TermImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getTerm()
		 * @generated
		 */
		EClass TERM = eINSTANCE.getTerm();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.TRUEImpl <em>TRUE</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.TRUEImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getTRUE()
		 * @generated
		 */
		EClass TRUE = eINSTANCE.getTRUE();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.BinaryOperatorImpl <em>Binary Operator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.BinaryOperatorImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getBinaryOperator()
		 * @generated
		 */
		EClass BINARY_OPERATOR = eINSTANCE.getBinaryOperator();

		/**
		 * The meta object literal for the '<em><b>Terms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BINARY_OPERATOR__TERMS = eINSTANCE.getBinaryOperator_Terms();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.ANDImpl <em>AND</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.ANDImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getAND()
		 * @generated
		 */
		EClass AND = eINSTANCE.getAND();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.ORImpl <em>OR</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.ORImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getOR()
		 * @generated
		 */
		EClass OR = eINSTANCE.getOR();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.NOTImpl <em>NOT</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.NOTImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getNOT()
		 * @generated
		 */
		EClass NOT = eINSTANCE.getNOT();

		/**
		 * The meta object literal for the '<em><b>Negated Term</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOT__NEGATED_TERM = eINSTANCE.getNOT_NegatedTerm();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.LabelReferenceImpl <em>Label Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.LabelReferenceImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getLabelReference()
		 * @generated
		 */
		EClass LABEL_REFERENCE = eINSTANCE.getLabelReference();

		/**
		 * The meta object literal for the '<em><b>Label</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LABEL_REFERENCE__LABEL = eINSTANCE.getLabelReference_Label();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.SetAssignmentImpl <em>Set Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.SetAssignmentImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getSetAssignment()
		 * @generated
		 */
		EClass SET_ASSIGNMENT = eINSTANCE.getSetAssignment();

		/**
		 * The meta object literal for the '<em><b>Output Labels</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SET_ASSIGNMENT__OUTPUT_LABELS = eINSTANCE.getSetAssignment_OutputLabels();

		/**
		 * The meta object literal for the '{@link org.dataflowanalysis.dfd.datadictionary.impl.UnsetAssignmentImpl <em>Unset Assignment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.UnsetAssignmentImpl
		 * @see org.dataflowanalysis.dfd.datadictionary.impl.datadictionaryPackageImpl#getUnsetAssignment()
		 * @generated
		 */
		EClass UNSET_ASSIGNMENT = eINSTANCE.getUnsetAssignment();

		/**
		 * The meta object literal for the '<em><b>Output Labels</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference UNSET_ASSIGNMENT__OUTPUT_LABELS = eINSTANCE.getUnsetAssignment_OutputLabels();

	}

} //datadictionaryPackage
