/**
 */
package org.dataflowanalysis.dfd.datadictionary.util;

import org.dataflowanalysis.dfd.datadictionary.*;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import tools.mdsd.modelingfoundations.identifier.Entity;
import tools.mdsd.modelingfoundations.identifier.Identifier;
import tools.mdsd.modelingfoundations.identifier.NamedElement;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.dataflowanalysis.dfd.datadictionary.datadictionaryPackage
 * @generated
 */
public class datadictionarySwitch<T> extends Switch<T>
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static datadictionaryPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public datadictionarySwitch()
	{
		if (modelPackage == null)
		{
			modelPackage = datadictionaryPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage)
	{
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject)
	{
		switch (classifierID)
		{
			case datadictionaryPackage.DATA_DICTIONARY:
			{
				DataDictionary dataDictionary = (DataDictionary)theEObject;
				T result = caseDataDictionary(dataDictionary);
				if (result == null) result = caseEntity(dataDictionary);
				if (result == null) result = caseIdentifier(dataDictionary);
				if (result == null) result = caseNamedElement(dataDictionary);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.BEHAVIOR:
			{
				Behavior behavior = (Behavior)theEObject;
				T result = caseBehavior(behavior);
				if (result == null) result = caseEntity(behavior);
				if (result == null) result = caseIdentifier(behavior);
				if (result == null) result = caseNamedElement(behavior);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.PIN:
			{
				Pin pin = (Pin)theEObject;
				T result = casePin(pin);
				if (result == null) result = caseEntity(pin);
				if (result == null) result = caseIdentifier(pin);
				if (result == null) result = caseNamedElement(pin);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.ABSTRACT_ASSIGNMENT:
			{
				AbstractAssignment abstractAssignment = (AbstractAssignment)theEObject;
				T result = caseAbstractAssignment(abstractAssignment);
				if (result == null) result = caseEntity(abstractAssignment);
				if (result == null) result = caseIdentifier(abstractAssignment);
				if (result == null) result = caseNamedElement(abstractAssignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.ASSIGNMENT:
			{
				Assignment assignment = (Assignment)theEObject;
				T result = caseAssignment(assignment);
				if (result == null) result = caseAbstractAssignment(assignment);
				if (result == null) result = caseEntity(assignment);
				if (result == null) result = caseIdentifier(assignment);
				if (result == null) result = caseNamedElement(assignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.FORWARDING_ASSIGNMENT:
			{
				ForwardingAssignment forwardingAssignment = (ForwardingAssignment)theEObject;
				T result = caseForwardingAssignment(forwardingAssignment);
				if (result == null) result = caseAbstractAssignment(forwardingAssignment);
				if (result == null) result = caseEntity(forwardingAssignment);
				if (result == null) result = caseIdentifier(forwardingAssignment);
				if (result == null) result = caseNamedElement(forwardingAssignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.LABEL:
			{
				Label label = (Label)theEObject;
				T result = caseLabel(label);
				if (result == null) result = caseEntity(label);
				if (result == null) result = caseIdentifier(label);
				if (result == null) result = caseNamedElement(label);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.LABEL_TYPE:
			{
				LabelType labelType = (LabelType)theEObject;
				T result = caseLabelType(labelType);
				if (result == null) result = caseEntity(labelType);
				if (result == null) result = caseIdentifier(labelType);
				if (result == null) result = caseNamedElement(labelType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.TERM:
			{
				Term term = (Term)theEObject;
				T result = caseTerm(term);
				if (result == null) result = caseEntity(term);
				if (result == null) result = caseIdentifier(term);
				if (result == null) result = caseNamedElement(term);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.TRUE:
			{
				TRUE true_ = (TRUE)theEObject;
				T result = caseTRUE(true_);
				if (result == null) result = caseTerm(true_);
				if (result == null) result = caseEntity(true_);
				if (result == null) result = caseIdentifier(true_);
				if (result == null) result = caseNamedElement(true_);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.BINARY_OPERATOR:
			{
				BinaryOperator binaryOperator = (BinaryOperator)theEObject;
				T result = caseBinaryOperator(binaryOperator);
				if (result == null) result = caseTerm(binaryOperator);
				if (result == null) result = caseEntity(binaryOperator);
				if (result == null) result = caseIdentifier(binaryOperator);
				if (result == null) result = caseNamedElement(binaryOperator);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.AND:
			{
				AND and = (AND)theEObject;
				T result = caseAND(and);
				if (result == null) result = caseBinaryOperator(and);
				if (result == null) result = caseTerm(and);
				if (result == null) result = caseEntity(and);
				if (result == null) result = caseIdentifier(and);
				if (result == null) result = caseNamedElement(and);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.OR:
			{
				OR or = (OR)theEObject;
				T result = caseOR(or);
				if (result == null) result = caseBinaryOperator(or);
				if (result == null) result = caseTerm(or);
				if (result == null) result = caseEntity(or);
				if (result == null) result = caseIdentifier(or);
				if (result == null) result = caseNamedElement(or);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.NOT:
			{
				NOT not = (NOT)theEObject;
				T result = caseNOT(not);
				if (result == null) result = caseTerm(not);
				if (result == null) result = caseEntity(not);
				if (result == null) result = caseIdentifier(not);
				if (result == null) result = caseNamedElement(not);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.LABEL_REFERENCE:
			{
				LabelReference labelReference = (LabelReference)theEObject;
				T result = caseLabelReference(labelReference);
				if (result == null) result = caseTerm(labelReference);
				if (result == null) result = caseEntity(labelReference);
				if (result == null) result = caseIdentifier(labelReference);
				if (result == null) result = caseNamedElement(labelReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.SET_ASSIGNMENT:
			{
				SetAssignment setAssignment = (SetAssignment)theEObject;
				T result = caseSetAssignment(setAssignment);
				if (result == null) result = caseAbstractAssignment(setAssignment);
				if (result == null) result = caseEntity(setAssignment);
				if (result == null) result = caseIdentifier(setAssignment);
				if (result == null) result = caseNamedElement(setAssignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case datadictionaryPackage.UNSET_ASSIGNMENT:
			{
				UnsetAssignment unsetAssignment = (UnsetAssignment)theEObject;
				T result = caseUnsetAssignment(unsetAssignment);
				if (result == null) result = caseAbstractAssignment(unsetAssignment);
				if (result == null) result = caseEntity(unsetAssignment);
				if (result == null) result = caseIdentifier(unsetAssignment);
				if (result == null) result = caseNamedElement(unsetAssignment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Data Dictionary</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Data Dictionary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDataDictionary(DataDictionary object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Behavior</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Behavior</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBehavior(Behavior object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Pin</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Pin</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePin(Pin object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractAssignment(AbstractAssignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAssignment(Assignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Forwarding Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Forwarding Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseForwardingAssignment(ForwardingAssignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Label</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Label</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLabel(Label object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Label Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Label Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLabelType(LabelType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Term</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Term</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTerm(Term object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TRUE</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TRUE</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTRUE(TRUE object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Binary Operator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Binary Operator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBinaryOperator(BinaryOperator object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>AND</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>AND</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAND(AND object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>OR</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>OR</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOR(OR object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>NOT</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>NOT</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNOT(NOT object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Label Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Label Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLabelReference(LabelReference object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Set Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Set Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSetAssignment(SetAssignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unset Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unset Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnsetAssignment(UnsetAssignment object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedElement(NamedElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntity(Entity object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object)
	{
		return null;
	}

} //datadictionarySwitch
