/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.loadbalancingaction.strategy;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.loadbalancingaction.loadbalancing.LoadbalancingBranchTransition;
import org.palladiosimulator.loadbalancingaction.strategy.AbstractStrategy;
import org.palladiosimulator.loadbalancingaction.strategy.JobSlotStrategyHelper;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class JobSlotFirstFitStrategy
extends AbstractStrategy {
    private volatile ResourceContainer targetContainer;
    private Long requiredSlots;
    private volatile boolean wokeUp;
    private final JobSlotStrategyHelper helper;

    public JobSlotFirstFitStrategy(InterpreterDefaultContext context, JobSlotStrategyHelper helper) {
        super(context);
        this.helper = helper;
        this.wokeUp = false;
        if (helper.systemAssemblyContext == null) {
            helper.systemAssemblyContext = (AssemblyContext)context.getAssemblyContextStack().get(0);
            helper.isActive = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public LoadbalancingBranchTransition determineBranch(EList<LoadbalancingBranchTransition> branchTransitions) {
        this.requiredSlots = this.evaluateRequiredSlots();
        if (this.helper.hasToBeQueued(this.requiredSlots)) {
            this.putJobInQueueAndPassivate();
        } else {
            LoadbalancingBranchTransition branchTransition = this.findBranchWithFreeSlots(branchTransitions, this.requiredSlots);
            if (branchTransition != null) {
                return branchTransition;
            }
            this.putJobInQueueAndPassivate();
        }
        while (!this.wokeUp) {
            this.context.getThread().passivate();
        }
        return this.findBranchToContainer(branchTransitions);
    }

    private LoadbalancingBranchTransition findBranchWithFreeSlots(EList<LoadbalancingBranchTransition> branchTransitions, Long requiredSlots) {
        for (LoadbalancingBranchTransition branchTransition : branchTransitions) {
            ResourceContainer container = this.helper.getResourceContainerForBranch(branchTransition, this.context);
            Long freeSlots = this.helper.getFreeSlotsOfContainer(container, this.context);
            long remainingSlots = freeSlots - requiredSlots;
            if (remainingSlots < 0L) continue;
            this.helper.resourceContainerSlots.put(container, remainingSlots);
            return branchTransition;
        }
        return null;
    }

    private LoadbalancingBranchTransition findBranchToContainer(EList<LoadbalancingBranchTransition> branchTransitions) {
        for (LoadbalancingBranchTransition branchTransition : branchTransitions) {
            ResourceContainer container = this.helper.getResourceContainerForBranch(branchTransition, this.context);
            if (!container.equals(this.targetContainer)) continue;
            Long freeSlots = this.helper.getFreeSlotsOfContainer(container, this.context);
            if (freeSlots < 0L) {
                throw new PCMModelInterpreterException("Job got scheduled on container with too less resources");
            }
            return branchTransition;
        }
        return null;
    }

    private Long evaluateRequiredSlots() {
        return (Long)StackContext.evaluateStatic((String)"NUMBER_REQUIRED_RESOURCES.VALUE", Long.class, (SimulatedStackframe)this.context.getStack().currentStackFrame());
    }

    private void putJobInQueueAndPassivate() {
        this.helper.jobQueue.add(this);
        System.out.println("Put job to sleep. Queue Length: " + this.helper.jobQueue.size());
        this.context.getThread().passivate();
    }

    public void setTargetContainer(ResourceContainer container) {
        this.targetContainer = container;
    }

    public void activate() {
        this.wokeUp = true;
        this.context.getThread().activate();
    }

    public Long getRequiredSlots() {
        return this.requiredSlots;
    }
}

