/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.loadbalancingaction.strategy;

import javax.inject.Inject;
import javax.inject.Provider;
import org.palladiosimulator.loadbalancingaction.loadbalancing.LoadbalancingStrategy;
import org.palladiosimulator.loadbalancingaction.strategy.JobSlotFirstFitStrategy;
import org.palladiosimulator.loadbalancingaction.strategy.JobSlotStrategyHelper;
import org.palladiosimulator.loadbalancingaction.strategy.RandomStrategy;
import org.palladiosimulator.loadbalancingaction.strategy.Strategy;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class StrategyFactory {
    private final Provider<JobSlotStrategyHelper> strategyHelperProvider;

    @Inject
    public StrategyFactory(Provider<JobSlotStrategyHelper> strategyHelperProvider) {
        this.strategyHelperProvider = strategyHelperProvider;
    }

    public Strategy createStrategy(LoadbalancingStrategy strategyEnum, InterpreterDefaultContext context) {
        return switch (strategyEnum) {
            case LoadbalancingStrategy.RANDOM -> new RandomStrategy(context);
            case LoadbalancingStrategy.JOBSLOT_FIRSTFIT -> new JobSlotFirstFitStrategy(context, (JobSlotStrategyHelper)this.strategyHelperProvider.get());
            default -> null;
        };
    }
}

