/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.loadbalancingaction.loadbalancing;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LoadbalancingStrategy implements Enumerator
{
    RANDOM(0, "RANDOM", "RANDOM"),
    JOBSLOT_FIRSTFIT(1, "JOBSLOT_FIRSTFIT", "JOBSLOT_FIRSTFIT");

    public static final int RANDOM_VALUE = 0;
    public static final int JOBSLOT_FIRSTFIT_VALUE = 1;
    private static final LoadbalancingStrategy[] VALUES_ARRAY;
    public static final List<LoadbalancingStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LoadbalancingStrategy[]{RANDOM, JOBSLOT_FIRSTFIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LoadbalancingStrategy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoadbalancingStrategy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoadbalancingStrategy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoadbalancingStrategy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoadbalancingStrategy get(int value) {
        switch (value) {
            case 0: {
                return RANDOM;
            }
            case 1: {
                return JOBSLOT_FIRSTFIT;
            }
        }
        return null;
    }

    private LoadbalancingStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

