/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.loadbalancingaction.strategy;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.loadbalancingaction.loadbalancing.LoadbalancingBranchTransition;
import org.palladiosimulator.loadbalancingaction.strategy.JobSlotFirstFitStrategy;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.simulizar.di.base.scopes.RuntimeExtensionScope;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.runtimestate.ComponentInstanceRegistry;
import org.palladiosimulator.simulizar.runtimestate.FQComponentID;
import org.palladiosimulator.simulizar.runtimestate.SimulatedBasicComponentInstance;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;

@RuntimeExtensionScope
public class JobSlotStrategyHelper {
    public static final String MIDDLEWARE_PASSIVE_RESOURCE_COMPONENT_NAME = "MiddlewarePassiveResource";
    public static final String REQUIRED_SLOTS_PARAMETER_SPECIFICATION = "NUMBER_REQUIRED_RESOURCES.VALUE";
    public static final String COMPUTE_COMPONENT_NAME = "computeJob";
    public final List<JobSlotFirstFitStrategy> jobQueue = Collections.synchronizedList(new ArrayList());
    public final Map<LoadbalancingBranchTransition, ResourceContainer> branchMapping = Collections.synchronizedMap(new HashMap());
    public final Map<ResourceContainer, Long> resourceContainerSlots = Collections.synchronizedMap(new HashMap());
    public static final int QUEUE_LENGTH_TO_SEARCH = 1;
    public boolean isActive = false;
    public AssemblyContext systemAssemblyContext;
    private final ComponentInstanceRegistry componentRegistry;

    @Inject
    public JobSlotStrategyHelper(ComponentInstanceRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public void jobFinished(AssemblyContext assemblyFinished, InterpreterDefaultContext context) {
        Allocation allocation = context.getLocalPCMModelAtContextCreation().getAllocation();
        ResourceContainer container = JobSlotStrategyHelper.findResourceContainer(assemblyFinished, allocation);
        AssemblyContext middlewarePassiveAssembly = JobSlotStrategyHelper.findMiddlewarePassiveAssembly(container, allocation);
        PassiveResource passiveResource = (PassiveResource)((BasicComponent)middlewarePassiveAssembly.getEncapsulatedComponent__AssemblyContext()).getPassiveResource_BasicComponent().get(0);
        Long freeSlots = this.getPassiveResourceAvailable(passiveResource, this.getFQComponentIDForMiddleware(middlewarePassiveAssembly), context);
        this.resourceContainerSlots.put(container, freeSlots);
        this.activateFitting(container);
    }

    public boolean hasToBeQueued(long requiredSlots) {
        if (this.jobQueue.isEmpty()) {
            return false;
        }
        if (this.jobQueue.size() >= 1) {
            return true;
        }
        return this.jobQueue.stream().anyMatch(entry -> entry.getRequiredSlots() <= requiredSlots);
    }

    public void reset() {
        this.jobQueue.clear();
        this.branchMapping.clear();
        this.resourceContainerSlots.clear();
        this.isActive = false;
        this.systemAssemblyContext = null;
    }

    public ResourceContainer getResourceContainerForBranch(LoadbalancingBranchTransition branchTransition, InterpreterDefaultContext context) {
        ResourceContainer container = this.branchMapping.get(branchTransition);
        if (container == null) {
            AssemblyConnector assemblyConnectorToLoadbalanced = JobSlotStrategyHelper.findAssemblyConnectorToLoadbalancedComponent(branchTransition, context);
            AssemblyContext loadbalancedAssemblyContext = assemblyConnectorToLoadbalanced.getProvidingAssemblyContext_AssemblyConnector();
            container = JobSlotStrategyHelper.findResourceContainer(loadbalancedAssemblyContext, context.getLocalPCMModelAtContextCreation().getAllocation());
            this.branchMapping.put(branchTransition, container);
        }
        return container;
    }

    public Long getFreeSlotsOfContainer(ResourceContainer container, InterpreterDefaultContext context) {
        Long freeSlots = this.resourceContainerSlots.get(container);
        if (freeSlots == null) {
            freeSlots = this.findFreeSlotsOfContainer(container, context);
            this.resourceContainerSlots.put(container, freeSlots);
        }
        return freeSlots;
    }

    public void activateFitting(ResourceContainer container) {
        Long freeSlots = this.resourceContainerSlots.get(container);
        if (freeSlots == 0L) {
            return;
        }
        int i = 0;
        boolean found = false;
        Iterator<JobSlotFirstFitStrategy> it = this.jobQueue.iterator();
        while (it.hasNext() && i < 1) {
            JobSlotFirstFitStrategy job = it.next();
            if (job.getRequiredSlots() <= freeSlots) {
                System.out.println("Found thread to wake up at position " + i);
                found = true;
                it.remove();
                this.resourceContainerSlots.put(container, freeSlots - job.getRequiredSlots());
                JobSlotStrategyHelper.activateJobOnContainer(job, container);
                break;
            }
            ++i;
        }
        if (found) {
            this.activateOnOtherContainer();
        } else {
            System.out.println("Did not find thread to wake up");
        }
    }

    private void activateOnOtherContainer() {
        JobSlotFirstFitStrategy job = this.jobQueue.get(0);
        boolean found = false;
        for (Map.Entry<ResourceContainer, Long> entry : this.resourceContainerSlots.entrySet()) {
            if (job.getRequiredSlots() > entry.getValue()) continue;
            System.out.println("Wake up thread.");
            found = true;
            this.jobQueue.remove(0);
            this.resourceContainerSlots.put(entry.getKey(), entry.getValue() - job.getRequiredSlots());
            JobSlotStrategyHelper.activateJobOnContainer(job, entry.getKey());
            break;
        }
        if (found) {
            this.activateOnOtherContainer();
        } else {
            System.out.println("Queue blocked.");
        }
    }

    private long findFreeSlotsOfContainer(ResourceContainer container, InterpreterDefaultContext context) {
        AssemblyContext middlewarePassiveAssembly = JobSlotStrategyHelper.findMiddlewarePassiveAssembly(container, context.getLocalPCMModelAtContextCreation().getAllocation());
        FQComponentID middlewareFQComponentID = this.getFQComponentIDForMiddleware(middlewarePassiveAssembly);
        PassiveResource passiveResource = (PassiveResource)((BasicComponent)middlewarePassiveAssembly.getEncapsulatedComponent__AssemblyContext()).getPassiveResource_BasicComponent().get(0);
        long freeSlots = this.isComponentRegistered(middlewareFQComponentID) ? this.getPassiveResourceAvailable(passiveResource, middlewareFQComponentID, context) : JobSlotStrategyHelper.getPassiveResourceCapacity(middlewarePassiveAssembly, passiveResource, context);
        return freeSlots;
    }

    private static AssemblyConnector findAssemblyConnectorToLoadbalancedComponent(LoadbalancingBranchTransition branchTransition, InterpreterDefaultContext context) {
        AssemblyContext loadbalancingActionAssembly = (AssemblyContext)context.getAssemblyContextStack().peek();
        RequiredRole requiredRole = (RequiredRole)branchTransition.getBranchBehaviour_LoadbalancingBranchTransition().getSteps_Behaviour().stream().filter(ExternalCallAction.class::isInstance).map(ExternalCallAction.class::cast).map(ExternalCallAction::getRole_ExternalService).findFirst().orElseThrow(() -> new PCMModelInterpreterException("No ExternalCallAction with OperationRequiredRole for loadbalancing branch found."));
        AssemblyConnector assemblyConnector = loadbalancingActionAssembly.getParentStructure__AssemblyContext().getConnectors__ComposedStructure().stream().filter(AssemblyConnector.class::isInstance).map(AssemblyConnector.class::cast).filter(a -> a.getRequiringAssemblyContext_AssemblyConnector() == loadbalancingActionAssembly && a.getRequiredRole_AssemblyConnector() == requiredRole).findFirst().orElseThrow(() -> new PCMModelInterpreterException("Loadbalancing required role is not connected: " + requiredRole));
        return assemblyConnector;
    }

    private static long getPassiveResourceCapacity(AssemblyContext middlewarePassiveAssembly, PassiveResource passiveResource, InterpreterDefaultContext context) {
        SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack)context.getStack(), (EList)middlewarePassiveAssembly.getConfigParameterUsages__AssemblyContext(), (SimulatedStackframe)context.getStack().currentStackFrame());
        long capacity = (Long)StackContext.evaluateStatic((String)passiveResource.getCapacity_PassiveResource().getSpecification(), Long.class, (SimulatedStackframe)context.getStack().currentStackFrame());
        context.getStack().removeStackFrame();
        return capacity;
    }

    private boolean isComponentRegistered(FQComponentID fqID) {
        return this.componentRegistry.hasComponentInstance(fqID);
    }

    private static ResourceContainer findResourceContainer(AssemblyContext providingAssemblyContext, Allocation allocation) {
        return allocation.getAllocationContexts_Allocation().stream().filter(alloc -> alloc.getAssemblyContext_AllocationContext().getId().equals(providingAssemblyContext.getId())).findFirst().orElseThrow(() -> new PCMModelInterpreterException("No allocation context for assembly context found: " + providingAssemblyContext)).getResourceContainer_AllocationContext();
    }

    private FQComponentID getFQComponentIDForMiddleware(AssemblyContext middleware) {
        Stack<AssemblyContext> assemblyStack = new Stack<AssemblyContext>();
        assemblyStack.push(this.systemAssemblyContext);
        assemblyStack.push(middleware);
        FQComponentID fqID = new FQComponentID(assemblyStack);
        return fqID;
    }

    private static void activateJobOnContainer(JobSlotFirstFitStrategy job, ResourceContainer container) {
        job.setTargetContainer(container);
        job.activate();
    }

    private static AssemblyContext findMiddlewarePassiveAssembly(ResourceContainer container, Allocation allocation) {
        Stream<AllocationContext> allocsOnContainer = allocation.getAllocationContexts_Allocation().stream().filter(alloc -> alloc.getResourceContainer_AllocationContext().equals(container));
        AssemblyContext middlewarePassiveAssembly = allocsOnContainer.map(AllocationContext::getAssemblyContext_AllocationContext).filter(a -> a.getEncapsulatedComponent__AssemblyContext().getEntityName().equals(MIDDLEWARE_PASSIVE_RESOURCE_COMPONENT_NAME)).findFirst().orElseThrow(() -> new PCMModelInterpreterException("Did not find middleware passive resource component for resource container: " + container));
        return middlewarePassiveAssembly;
    }

    private long getPassiveResourceAvailable(PassiveResource passiveResource, FQComponentID middlewareFQComponentID, InterpreterDefaultContext context) {
        SimulatedBasicComponentInstance simulatedInstance = (SimulatedBasicComponentInstance)this.componentRegistry.getComponentInstance(middlewareFQComponentID);
        return simulatedInstance.getAvailablePassiveResource(passiveResource, context);
    }
}

