/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.ocl;

import de.uka.ipd.sdq.simucomframework.core.Context;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;

public class StereotypeEvaluationEnvironment
extends EcoreEvaluationEnvironment {
    private final MDSDBlackboard blackboard;

    public StereotypeEvaluationEnvironment(EcoreEnvironmentFactory factory, MDSDBlackboard blackboard) {
        super(factory);
        this.blackboard = blackboard;
    }

    public StereotypeEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent, MDSDBlackboard blackboard) {
        super(parent);
        this.blackboard = blackboard;
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) {
        if (operation.getEAnnotation("StereotypeEnvironment") == null) {
            return super.callOperation(operation, opcode, source, args);
        }
        switch (operation.getName()) {
            case "hasAppliedStereotype": {
                return StereotypeAPI.isStereotypeApplied((EObject)((Entity)source), (String)((String)args[0]));
            }
            case "getDoubleTaggedValue": 
            case "getStringTaggedValue": {
                return StereotypeAPI.getTaggedValue((EObject)((Entity)source), (String)((String)args[0]), (String)((String)args[1]));
            }
            case "parseDouble": {
                return Double.parseDouble((String)source);
            }
            case "getAllocation": {
                return this.getAllocation();
            }
            case "getResourceEnvironment": {
                return this.getResourceEnvironment();
            }
            case "evaluateStoEx": {
                return Context.evaluateStatic((String)((String)source), Double.class);
            }
        }
        throw new UnsupportedOperationException();
    }

    private ResourceEnvironment getResourceEnvironment() {
        PCMResourceSetPartition pcmRepositoryPartition = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        ResourceEnvironment resEnv = null;
        try {
            resEnv = pcmRepositoryPartition.getResourceEnvironment();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (resEnv == null) {
            throw new RuntimeException("Did not find Resource Environment.");
        }
        return resEnv;
    }

    private Allocation getAllocation() {
        PCMResourceSetPartition pcmRepositoryPartition = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        Allocation allocation = null;
        try {
            allocation = pcmRepositoryPartition.getAllocation();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (allocation == null) {
            throw new RuntimeException("Did not find Allocation.");
        }
        return allocation;
    }
}

