/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.ui.dialogs;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.modelversioning.emfprofile.Stereotype;
import org.palladiosimulator.architecturaltemplates.api.ArchitecturalTemplateAPI;
import org.palladiosimulator.commons.eclipseutils.FileHelper;

public class RoleStereotypeSelectionDialog
extends ElementListSelectionDialog {
    private static final String EMPTY_LIST_MESSAGE = "No Role-Stereotypes can be selected";
    private static final String TITLE = "Select Role-Stereotype";
    private static final String EMPTY_SELECTION_MESSAGE = "You need to select a Role-Stereotype to continue";

    public RoleStereotypeSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new LabelProvider(){
            private Image roleImage = null;

            public String getText(Object element) {
                return ((Stereotype)element).getName();
            }

            public Image getImage(Object element) {
                if (this.roleImage == null) {
                    try {
                        this.roleImage = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(FileHelper.getFile((String)"platform:plugin/org.palladiosimulator.architecturaltemplates.edit/icons/full/obj16/Role.gif")));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                return this.roleImage;
            }

            public void dispose() {
                super.dispose();
                if (this.roleImage != null) {
                    this.roleImage.dispose();
                }
            }
        });
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                return selection.length == 1 ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        });
        this.setTitle(TITLE);
        this.setEmptySelectionMessage(EMPTY_SELECTION_MESSAGE);
        this.setEmptyListMessage(EMPTY_LIST_MESSAGE);
    }

    public void setElements(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!(o instanceof Stereotype) || !ArchitecturalTemplateAPI.isRole((Stereotype)((Stereotype)o))) {
                throw new IllegalArgumentException("All elements must be of type \"Stereotype\"");
            }
            ++n2;
        }
        super.setElements(elements);
    }

    public Stereotype getResultRoleStereotype() {
        return (Stereotype)this.getResult()[0];
    }
}

