/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.architecturaltemplates.Role;

public final class C3RoleLinearization {
    private C3RoleLinearization() {
    }

    public static List<Role> linearize(Role roleToLinearize) {
        return Collections.unmodifiableList(C3RoleLinearization.linearizeInternal(roleToLinearize));
    }

    public static List<Role> linearizeReversed(Role roleToLinearize) {
        List<Role> linearization = C3RoleLinearization.linearizeInternal(roleToLinearize);
        Collections.reverse(linearization);
        return Collections.unmodifiableList(linearization);
    }

    private static List<Role> linearizeInternal(Role roleToLinearize) {
        ArrayList<List<Role>> ancestorLists = new ArrayList<List<Role>>();
        ArrayList<Role> linearization = new ArrayList<Role>();
        linearization.add(roleToLinearize);
        EList<Role> superroles = roleToLinearize.getSuperRoles();
        for (Role superrole : superroles) {
            ancestorLists.add(C3RoleLinearization.linearizeInternal(superrole));
        }
        if (!superroles.isEmpty()) {
            ancestorLists.add((List<Role>)superroles);
        }
        C3RoleLinearization.merge(ancestorLists, linearization);
        return linearization;
    }

    private static void merge(List<List<Role>> ancestorLists, List<Role> linearization) {
        boolean foundGoodHead = false;
        ArrayList<List<Role>> ancestorListsCopy = new ArrayList<List<Role>>(ancestorLists);
        for (List list : ancestorListsCopy) {
            Role head = C3RoleLinearization.headOf(list);
            if (C3RoleLinearization.isTailInOthers(head, list, ancestorListsCopy)) continue;
            linearization.add(head);
            C3RoleLinearization.removeFromAllAncestorLists(head, ancestorLists);
            foundGoodHead = true;
            break;
        }
        if (ancestorLists.isEmpty()) {
            return;
        }
        if (!foundGoodHead) {
            throw new RuntimeException("No consistent linearization.");
        }
        C3RoleLinearization.merge(ancestorLists, linearization);
    }

    private static Role headOf(List<Role> ancestors) {
        return ancestors.get(0);
    }

    private static List<Role> tailOf(List<Role> ancestors) {
        return ancestors.subList(1, ancestors.size());
    }

    private static boolean isTailInOthers(Role head, List<Role> currentAncestorList, List<List<Role>> ancestorListsCopy) {
        for (List<Role> list : ancestorListsCopy) {
            if (list.equals(currentAncestorList) || !C3RoleLinearization.tailOf(list).contains(head)) continue;
            return true;
        }
        return false;
    }

    private static void removeFromAllAncestorLists(Role role, List<List<Role>> ancestorLists) {
        for (List<Role> list : ancestorLists) {
            list.remove(role);
        }
        C3RoleLinearization.removeEmptyAncestorLists(ancestorLists);
    }

    private static void removeEmptyAncestorLists(List<List<Role>> ancestorLists) {
        Iterator<List<Role>> ancestorListsIterator = ancestorLists.iterator();
        while (ancestorListsIterator.hasNext()) {
            if (!ancestorListsIterator.next().isEmpty()) continue;
            ancestorListsIterator.remove();
        }
    }
}

