/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.tests;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import org.palladiosimulator.architecturaltemplates.ArchitecturaltemplatesFactory;
import org.palladiosimulator.architecturaltemplates.Role;
import org.palladiosimulator.architecturaltemplates.util.C3RoleLinearization;

public class C3RoleLinearizationTest
extends TestCase {
    private static final ArchitecturaltemplatesFactory AT_FACTORY = ArchitecturaltemplatesFactory.eINSTANCE;
    private final Role z = AT_FACTORY.createRole();
    private final Role k1 = AT_FACTORY.createRole();
    private final Role k2 = AT_FACTORY.createRole();
    private final Role k3 = AT_FACTORY.createRole();
    private final Role a = AT_FACTORY.createRole();
    private final Role b = AT_FACTORY.createRole();
    private final Role c = AT_FACTORY.createRole();
    private final Role d = AT_FACTORY.createRole();
    private final Role e = AT_FACTORY.createRole();
    private final Role o = AT_FACTORY.createRole();

    protected void setUp() throws Exception {
        super.setUp();
        this.z.getSuperRoles().add((Object)this.k1);
        this.z.getSuperRoles().add((Object)this.k2);
        this.z.getSuperRoles().add((Object)this.k3);
        this.k1.getSuperRoles().add((Object)this.a);
        this.k1.getSuperRoles().add((Object)this.b);
        this.k1.getSuperRoles().add((Object)this.c);
        this.k2.getSuperRoles().add((Object)this.d);
        this.k2.getSuperRoles().add((Object)this.b);
        this.k2.getSuperRoles().add((Object)this.e);
        this.k3.getSuperRoles().add((Object)this.d);
        this.k3.getSuperRoles().add((Object)this.a);
        this.a.getSuperRoles().add((Object)this.o);
        this.b.getSuperRoles().add((Object)this.o);
        this.c.getSuperRoles().add((Object)this.o);
        this.d.getSuperRoles().add((Object)this.o);
        this.e.getSuperRoles().add((Object)this.o);
    }

    @Test
    public void testWikipediaRoleSerialization() {
        List linearization = C3RoleLinearization.linearize((Role)this.z);
        StringBuilder sb = new StringBuilder("[");
        Iterator iterator = linearization.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            sb.append(this.getName(role));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        C3RoleLinearizationTest.assertEquals((String)"[Z, K1, K2, K3, D, A, B, C, E, O]", (String)sb.toString());
    }

    private String getName(Role role) {
        if (this.z.equals(role)) {
            return "Z";
        }
        if (this.k1.equals(role)) {
            return "K1";
        }
        if (this.k2.equals(role)) {
            return "K2";
        }
        if (this.k3.equals(role)) {
            return "K3";
        }
        if (this.a.equals(role)) {
            return "A";
        }
        if (this.b.equals(role)) {
            return "B";
        }
        if (this.c.equals(role)) {
            return "C";
        }
        if (this.d.equals(role)) {
            return "D";
        }
        if (this.e.equals(role)) {
            return "E";
        }
        if (this.o.equals(role)) {
            return "O";
        }
        throw new IllegalArgumentException("Supplied role unknown.");
    }
}

