/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.core.runconfig.SimuComWorkflowConfiguration;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.SavePartitionToDiskJob;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.jobs.CreatePluginProjectJob;
import org.palladiosimulator.architecturaltemplates.jobs.config.ATExtensionJobConfiguration;
import org.palladiosimulator.architecturaltemplates.jobs.constants.ATPartitionConstants;
import org.palladiosimulator.commons.emfutils.EMFCopyHelper;

public class StoreCompletedModelsJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final String MODEL_GEN_FOLDER_NAME = "model-gen";
    private static final String AT_COPY_PARTITION = "AT_COPY";
    private static final AbstractPCMWorkflowRunConfiguration PLUGIN_CONFIGURATION = new SimuComWorkflowConfiguration(Collections.emptyMap());
    private final ATExtensionJobConfiguration configuration;
    private final String folderName;

    static {
        PLUGIN_CONFIGURATION.setDeleteTemporaryDataAfterAnalysis(false);
        PLUGIN_CONFIGURATION.setOverwriteWithoutAsking(true);
    }

    public StoreCompletedModelsJob(ATExtensionJobConfiguration configuration, String folderName, boolean createNewStorageFolder) {
        super(false);
        this.configuration = configuration;
        this.folderName = folderName;
        if (createNewStorageFolder) {
            PLUGIN_CONFIGURATION.setStoragePluginID(configuration.getModelStorageLocation());
            this.add((IJob)new CreatePluginProjectJob(PLUGIN_CONFIGURATION));
        }
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        super.execute(monitor);
        URI storageURI = URI.createPlatformResourceURI((String)this.configuration.getModelStorageLocation(), (boolean)false);
        ATPartitionConstants.Partition[] partitionArray = ATPartitionConstants.Partition.values();
        int n = partitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ATPartitionConstants.Partition partition = partitionArray[n2];
            ((MDSDBlackboard)this.getBlackboard()).addPartition(AT_COPY_PARTITION, (Object)this.copyPartition(partition, storageURI));
            this.storePartition(monitor, AT_COPY_PARTITION);
            ((MDSDBlackboard)this.getBlackboard()).removePartition(AT_COPY_PARTITION);
            ++n2;
        }
    }

    private ResourceSetPartition copyPartition(ATPartitionConstants.Partition partition, URI storageURI) {
        ResourceSetPartition partitionOriginal = (ResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition(partition.getPartitionId());
        ResourceSetPartition partitionCopy = new ResourceSetPartition();
        List elementsCopy = EMFCopyHelper.deepCopyToEObjectList((ResourceSet)partitionOriginal.getResourceSet());
        int elementCounter = 0;
        for (Resource r : partitionOriginal.getResourceSet().getResources()) {
            URI targetURI = storageURI.appendSegment(MODEL_GEN_FOLDER_NAME).appendSegment(this.folderName).appendSegment(partition.getName()).appendSegment(r.getURI().lastSegment());
            Resource resourceCopy = partitionCopy.getResourceSet().createResource(targetURI);
            int i = 0;
            while (i < r.getContents().size()) {
                resourceCopy.getContents().add((Object)((EObject)elementsCopy.get(elementCounter)));
                ++elementCounter;
                ++i;
            }
        }
        return partitionCopy;
    }

    private void storePartition(IProgressMonitor monitor, String partitionID) throws JobFailedException, UserCanceledException {
        SavePartitionToDiskJob savePartitionJob = new SavePartitionToDiskJob(partitionID);
        savePartitionJob.setBlackboard((MDSDBlackboard)this.getBlackboard());
        savePartitionJob.execute(monitor);
    }
}

