/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.cost.modelobserver;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEngineFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEventFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import org.apache.log4j.Logger;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.commons.designpatterns.IAbstractObservable;
import org.palladiosimulator.cost.modelobserver.CostModel;
import org.palladiosimulator.cost.modelobserver.IAbstractPeriodicContainerListener;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredSimulationEntity;

public class PeriodicallyTriggeredCostModelEntity
extends PeriodicallyTriggeredSimulationEntity
implements IAbstractObservable<IAbstractPeriodicContainerListener> {
    private static final Logger LOGGER = Logger.getLogger(PeriodicallyTriggeredSimulationEntity.class);
    private final CostModel costModel;
    private final double delay;
    private final AbstractObservable<IAbstractPeriodicContainerListener> observableDelegate;
    private final ISimulationTimeProvider timeProvider;

    @AssistedInject
    public PeriodicallyTriggeredCostModelEntity(ISimEngineFactory simFactory, ISimulationTimeProvider timeProvider, CostModel costModel, @Assisted double firstOccurrence, @Assisted double delay) {
        super((ISimEventFactory)simFactory, firstOccurrence, delay);
        this.timeProvider = timeProvider;
        this.costModel = costModel;
        this.delay = delay;
        this.observableDelegate = new AbstractObservable<IAbstractPeriodicContainerListener>(){};
    }

    protected void triggerInternal() {
        Double timestamp = this.timeProvider.getCurrentSimulationTime();
        if (LOGGER.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Periodic trigger for the cost model occured at time");
            stringBuilder.append(timestamp.toString());
            LOGGER.info((Object)stringBuilder.toString());
        }
        ((IAbstractPeriodicContainerListener)this.observableDelegate.getEventDispatcher()).triggerPeriodicUpdate(this.costModel, timestamp, this.delay);
    }

    public void addObserver(IAbstractPeriodicContainerListener observer) {
        this.observableDelegate.addObserver((Object)observer);
    }

    public void removeObserver(IAbstractPeriodicContainerListener observer) {
        this.observableDelegate.removeObserver((Object)observer);
    }

    @AssistedFactory
    public static interface Factory {
        public PeriodicallyTriggeredCostModelEntity create(double var1, double var3);
    }
}

