/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dataflow.confidentiality.pcm.dddsl.validation;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.palladiosimulator.dataflow.confidentiality.pcm.dddsl.validation.AbstractDDDslValidator;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourPackage;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.ReusableBehaviour;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.dictionary.DictionaryPackage;
import org.palladiosimulator.pcm.core.CorePackage;
import org.palladiosimulator.pcm.parameter.ParameterPackage;
import org.palladiosimulator.pcm.parameter.VariableUsage;

public class DDDslValidator
extends AbstractDDDslValidator {
    @Override
    protected List<EPackage> getEPackages() {
        ArrayList<EPackage> relevantPackages = new ArrayList<EPackage>(super.getEPackages());
        relevantPackages.removeIf(Objects::isNull);
        relevantPackages.add((EPackage)DictionaryPackage.eINSTANCE);
        relevantPackages.add((EPackage)BehaviourPackage.eINSTANCE);
        relevantPackages.add((EPackage)StoexPackage.eINSTANCE);
        relevantPackages.add((EPackage)ParameterPackage.eINSTANCE);
        relevantPackages.add((EPackage)CorePackage.eINSTANCE);
        return relevantPackages;
    }

    @Check
    public void checkVariableUsages(ReusableBehaviour behaviour) {
        HashSet<String> usedVariableNames = new HashSet<String>();
        for (VariableUsage variableUsage : behaviour.getVariableUsages()) {
            Optional<String> variableName = Optional.ofNullable(variableUsage.getNamedReference__VariableUsage()).map(AbstractNamedReference::getReferenceName);
            if (!variableName.isPresent() || usedVariableNames.add(variableName.get())) continue;
            this.error("There must only be one specification for an output variable.", (EObject)behaviour, (EStructuralFeature)BehaviourPackage.Literals.REUSABLE_BEHAVIOUR__VARIABLE_USAGES, behaviour.getVariableUsages().indexOf((Object)variableUsage));
        }
    }

    @Check
    public void checkReference(VariableReference reference) {
        String variableName = reference.getReferenceName();
        Optional<ReusableBehaviour> behaviour = DDDslValidator.findParentOfType((EObject)reference, ReusableBehaviour.class);
        boolean isLhs = reference.eContainer() instanceof VariableUsage;
        if (isLhs) {
            Collection<String> outputVariables = DDDslValidator.getVariableNames(behaviour, ReusableBehaviour::getOutputVariables);
            if (!outputVariables.contains(variableName)) {
                this.error("The left-hand-side of an assignment must only refer to output variables.", reference.eContainer(), (EStructuralFeature)ParameterPackage.Literals.VARIABLE_USAGE__NAMED_REFERENCE_VARIABLE_USAGE);
            }
        } else {
            Collection<String> inputVariables = DDDslValidator.getVariableNames(behaviour, ReusableBehaviour::getInputVariables);
            Boolean isRhs = DDDslValidator.findParentOfType((EObject)reference, ConfidentialityVariableCharacterisation.class).map(e -> DDDslValidator.isTransitiveChild((EObject)e, (EObject)reference)).orElse(false);
            if (isRhs.booleanValue() && !inputVariables.contains(variableName)) {
                this.error("The right-hand-side of an assignment must only refer to input variables.", reference.eContainer(), reference.eContainingFeature());
            }
        }
    }

    protected static Collection<String> getVariableNames(Optional<ReusableBehaviour> behaviour, Function<ReusableBehaviour, Collection<VariableReference>> getter) {
        return behaviour.map(b -> (Collection)getter.apply((ReusableBehaviour)b)).orElse((Collection)new BasicEList()).stream().map(AbstractNamedReference::getReferenceName).collect(Collectors.toList());
    }

    protected static <T extends EObject> Optional<T> findParentOfType(EObject obj, Class<T> type) {
        EObject current = obj;
        while (current != null && !type.isInstance(current)) {
            current = current.eContainer();
        }
        return Optional.ofNullable(current);
    }

    protected static boolean isTransitiveChild(EObject root, EObject child) {
        if (root.equals(child)) {
            return true;
        }
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            if (!child.equals(iter.next())) continue;
            return true;
        }
        return false;
    }
}

