/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dataflow.confidentiality.pcm.editor.sirius;

import com.google.inject.Injector;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.palladiosimulator.dataflow.confidentiality.pcm.dddsl.ui.internal.DddslActivator;
import org.palladiosimulator.dataflow.confidentiality.pcm.editor.sirius.QueryHelpers;
import org.palladiosimulator.dataflow.confidentiality.pcm.editor.sirius.assignments.SerializationHelper;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.Characteristic;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.CharacteristicTypeDictionary;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.Characteristics;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.CharacteristicsFactory;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.EnumCharacteristic;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.dictionary.PCMDataDictionary;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.profile.ProfileConstants;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Entity;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.EnumCharacteristicType;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Enumeration;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Literal;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.parameter.ParameterFactory;
import org.palladiosimulator.pcm.parameter.VariableUsage;

public class Services {
    protected static final SerializationHelper SERIALIZATION_HELPER = Services.createSerializationHelper();

    public String getConfidentialityVariableCharacterisationLabel(EObject self) throws IOException {
        if (!(self instanceof ConfidentialityVariableCharacterisation)) {
            return "invalid";
        }
        ConfidentialityVariableCharacterisation characterisation = (ConfidentialityVariableCharacterisation)self;
        return Services.serialize(characterisation);
    }

    public Collection<EnumCharacteristic> findAppliedEnumCharacteristics(EObject self) {
        Collection taggedValue = StereotypeAPI.getTaggedValueSafe((EObject)self, (String)ProfileConstants.characterisable.getValue(), (String)ProfileConstants.characterisable.getStereotype()).filter(Collection.class::isInstance).map(Collection.class::cast).orElse(Collections.emptyList());
        Collection enumCharacteristics = taggedValue.stream().filter(EnumCharacteristic.class::isInstance).map(EnumCharacteristic.class::cast).collect(Collectors.toList());
        return enumCharacteristics;
    }

    public Collection<EnumCharacteristicType> findAllEnumCharacteristicTypes(EObject self) {
        return QueryHelpers.findCharacteristicTypeDictionariesInSemanticResources(self).stream().map(CharacteristicTypeDictionary::getCharacteristicTypes).flatMap(Collection::stream).filter(EnumCharacteristicType.class::isInstance).map(EnumCharacteristicType.class::cast).collect(Collectors.toList());
    }

    public Characteristics getCharacteristicsContainer(EObject self) throws IOException {
        URI modelResourceURI = self.eResource().getURI();
        String modelFileName = modelResourceURI.lastSegment();
        String containerFileName = String.valueOf(modelFileName) + ".characteristics";
        URI containerResourceURI = modelResourceURI.trimSegments(1).appendSegment(containerFileName);
        Session session = SessionManager.INSTANCE.getSession(self);
        Optional<Resource> containerResource = session.getSemanticResources().stream().filter(r -> r.getURI().equals(containerResourceURI)).findFirst();
        if (containerResource.isEmpty()) {
            ResourceSet rs = session.getTransactionalEditingDomain().getResourceSet();
            if (!rs.getURIConverter().exists(containerResourceURI, Collections.emptyMap())) {
                Resource r2 = rs.createResource(containerResourceURI);
                r2.getContents().add((Object)CharacteristicsFactory.eINSTANCE.createCharacteristics());
                r2.save(Collections.emptyMap());
            }
            session.addSemanticResource(containerResourceURI, (IProgressMonitor)new NullProgressMonitor());
            containerResource = session.getSemanticResources().stream().filter(r -> r.getURI().equals(containerResourceURI)).findFirst();
        }
        return containerResource.map(Resource::getContents).map(Collection::iterator).map(Iterator::next).filter(Characteristics.class::isInstance).map(Characteristics.class::cast).orElse(null);
    }

    public String getLabelForEnumCharacteristic(EObject self) {
        if (self instanceof EnumCharacteristic) {
            EnumCharacteristic characteristic = (EnumCharacteristic)self;
            String typeName = Optional.ofNullable((EnumCharacteristicType)characteristic.getType()).map(Entity::getName).orElse("n/a");
            String values = characteristic.getValues().stream().map(Entity::getName).collect(Collectors.joining(", "));
            return String.format("%s: %s", typeName, values);
        }
        return null;
    }

    public Collection<Literal> getLiteralsFromEnumCharacteristic(EObject self) {
        return (Collection)Optional.ofNullable(self).filter(EnumCharacteristic.class::isInstance).map(EnumCharacteristic.class::cast).map(Characteristic::getType).map(EnumCharacteristicType::getType).map(Enumeration::getLiterals).orElse((EList)new BasicEList());
    }

    protected static String serialize(ConfidentialityVariableCharacterisation characterisation) throws IOException {
        Collection<CharacteristicTypeDictionary> dictionaries = QueryHelpers.findCharacteristicTypeDictionariesInSemanticResources((EObject)characterisation);
        PCMDataDictionary dict = SERIALIZATION_HELPER.buildSerializationModel(behaviour -> {
            VariableUsage usage = ParameterFactory.eINSTANCE.createVariableUsage();
            behaviour.getVariableUsages().add((Object)usage);
            behaviour.getInputVariables().clear();
            behaviour.getOutputVariables().clear();
            usage.setNamedReference__VariableUsage((AbstractNamedReference)EcoreUtil.copy((EObject)characterisation.getVariableUsage_VariableCharacterisation().getNamedReference__VariableUsage()));
            ConfidentialityVariableCharacterisation copy = (ConfidentialityVariableCharacterisation)EcoreUtil.copy((EObject)characterisation);
            usage.getVariableCharacterisation_VariableUsage().add((Object)copy);
        }, "", Arrays.asList(""), dictionaries);
        String dictString = SERIALIZATION_HELPER.serializeDict(dict, Arrays.asList(dict));
        Pattern blockPattern = Pattern.compile("\\{([^}]+)\\}");
        Matcher matcher = blockPattern.matcher(dictString);
        List blocks = matcher.results().collect(Collectors.toList());
        MatchResult lastBlock = (MatchResult)blocks.get(blocks.size() - 1);
        String lastBlockContent = lastBlock.group(1);
        return lastBlockContent.trim();
    }

    protected static SerializationHelper createSerializationHelper() {
        IEditedResourceProvider editedResourceProvider = (IEditedResourceProvider)Services.getInjector().getInstance(IEditedResourceProvider.class);
        return new SerializationHelper(editedResourceProvider);
    }

    protected static Injector getInjector() {
        return DddslActivator.getInstance().getInjector("org.palladiosimulator.dataflow.confidentiality.pcm.dddsl.DDDsl");
    }
}

