/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dataflow.confidentiality.pcm.editor.sirius;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.dataflow.confidentiality.pcm.editor.sirius.QueryHelpers;
import org.palladiosimulator.dataflow.confidentiality.pcm.editor.sirius.assignments.AssignmentsEditorFactoryProvider;
import org.palladiosimulator.dataflow.confidentiality.pcm.editor.sirius.assignments.AssignmentsEditorImpl;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.ConfidentialityVariableCharacterisation;
import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.CharacteristicTypeDictionary;
import org.palladiosimulator.indirections.actions.ConsumeDataAction;
import org.palladiosimulator.indirections.actions.CreateDateAction;
import org.palladiosimulator.indirections.actions.util.ActionsSwitch;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;

public class CreateVariableCharacterisationsViaEditor
implements IExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> context) {
        boolean isVariableUsage = context.stream().anyMatch(VariableUsage.class::isInstance);
        boolean isConfidentialityVariableCharacterisation = context.stream().anyMatch(ConfidentialityVariableCharacterisation.class::isInstance);
        return isVariableUsage || isConfidentialityVariableCharacterisation;
    }

    public void execute(Collection<? extends EObject> context, Map<String, Object> parameters) {
        Stream<EObject> contextParents = context.stream().filter(ConfidentialityVariableCharacterisation.class::isInstance).map(EObject::eContainer);
        VariableUsage variableUsage = Stream.concat(contextParents, context.stream()).filter(VariableUsage.class::isInstance).map(VariableUsage.class::cast).findFirst().get();
        this.adjustCharacterisations(variableUsage);
    }

    protected void adjustCharacterisations(VariableUsage variableUsage) {
        AssignmentsEditorImpl editor = this.buildTextualEditor(variableUsage);
        if (editor.open() != 0) {
            return;
        }
        this.replaceVariableCharacterisations(variableUsage, editor.getResult());
    }

    protected AssignmentsEditorImpl buildTextualEditor(VariableUsage variableUsage) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Collection<CharacteristicTypeDictionary> dictionaries = QueryHelpers.findCharacteristicTypeDictionariesInSemanticResources((EObject)variableUsage);
        String outputName = variableUsage.getNamedReference__VariableUsage().getReferenceName();
        Collection<String> inputNames = this.findInputs(variableUsage);
        return AssignmentsEditorFactoryProvider.getInstance().create(shell, outputName, inputNames, dictionaries, variableUsage);
    }

    protected Collection<String> findInputs(VariableUsage variableUsage) {
        ArrayList<String> inputs = new ArrayList<String>();
        inputs.addAll(CreateVariableCharacterisationsViaEditor.findParentOfType((EObject)variableUsage, ResourceDemandingSEFF.class).map(seff -> this.findInputs(variableUsage, (ResourceDemandingSEFF)seff)).orElse(Collections.emptyList()));
        inputs.addAll(CreateVariableCharacterisationsViaEditor.findParentOfType((EObject)variableUsage, ScenarioBehaviour.class).map(behaviour -> this.findInputs(variableUsage, (ScenarioBehaviour)behaviour)).orElse(Collections.emptyList()));
        return inputs;
    }

    protected Collection<String> findInputs(VariableUsage variableUsage, ScenarioBehaviour behaviour) {
        ArrayList<String> inputs = new ArrayList<String>();
        AbstractUserAction initialAction = CreateVariableCharacterisationsViaEditor.findParentOfType((EObject)variableUsage, AbstractUserAction.class).get();
        AbstractUserActionPredecessorIterator predecessorIter = new AbstractUserActionPredecessorIterator(initialAction);
        AbstractUserActionOutputVariablesSwitch variablesExtractor = new AbstractUserActionOutputVariablesSwitch();
        while (predecessorIter.hasNext()) {
            AbstractUserAction action = predecessorIter.next();
            inputs.addAll((Collection)variablesExtractor.doSwitch((EObject)action));
        }
        Boolean calledSignatureHasReturn = Optional.of(initialAction).filter(EntryLevelSystemCall.class::isInstance).map(EntryLevelSystemCall.class::cast).map(EntryLevelSystemCall::getOperationSignature__EntryLevelSystemCall).map(OperationSignature::getReturnType__OperationSignature).map(Objects::nonNull).orElse(false);
        if (calledSignatureHasReturn.booleanValue() && variableUsage.eContainmentFeature() == UsagemodelPackage.Literals.ENTRY_LEVEL_SYSTEM_CALL__OUTPUT_PARAMETER_USAGES_ENTRY_LEVEL_SYSTEM_CALL) {
            inputs.add("RETURN");
        }
        return inputs;
    }

    protected Collection<String> findInputs(VariableUsage variableUsage, ResourceDemandingSEFF seff) {
        ArrayList<String> inputs = new ArrayList<String>();
        if (seff.getDescribedService__SEFF() instanceof OperationSignature) {
            OperationSignature signature = (OperationSignature)seff.getDescribedService__SEFF();
            signature.getParameters__OperationSignature().stream().map(Parameter::getParameterName).forEach(inputs::add);
        }
        AbstractAction initialAction = CreateVariableCharacterisationsViaEditor.findParentOfType((EObject)variableUsage, AbstractAction.class).get();
        AbstractActionPredecessorIterator predecessorIter = new AbstractActionPredecessorIterator(initialAction);
        AbstractActionOutputVariablesSwitch variablesExtractor = new AbstractActionOutputVariablesSwitch();
        while (predecessorIter.hasNext()) {
            AbstractAction action = predecessorIter.next();
            inputs.addAll((Collection)variablesExtractor.doSwitch((EObject)action));
        }
        Boolean calledSignatureHasReturn = Optional.of(initialAction).filter(ExternalCallAction.class::isInstance).map(ExternalCallAction.class::cast).map(ExternalCallAction::getCalledService_ExternalService).map(OperationSignature::getReturnType__OperationSignature).map(Objects::nonNull).orElse(false);
        if (calledSignatureHasReturn.booleanValue() && variableUsage.eContainmentFeature() == SeffPackage.Literals.CALL_RETURN_ACTION__RETURN_VARIABLE_USAGE_CALL_RETURN_ACTION) {
            inputs.add("RETURN");
        }
        return inputs;
    }

    protected void replaceVariableCharacterisations(VariableUsage variableUsage, Collection<VariableUsage> definedUsages) {
        List characterisations = definedUsages.stream().filter(du -> variableUsage.getNamedReference__VariableUsage().getReferenceName().equals(du.getNamedReference__VariableUsage().getReferenceName())).map(VariableUsage::getVariableCharacterisation_VariableUsage).flatMap(Collection::stream).filter(ConfidentialityVariableCharacterisation.class::isInstance).map(ConfidentialityVariableCharacterisation.class::cast).map(EcoreUtil::copy).collect(Collectors.toList());
        variableUsage.getVariableCharacterisation_VariableUsage().removeIf(ConfidentialityVariableCharacterisation.class::isInstance);
        variableUsage.getVariableCharacterisation_VariableUsage().addAll(characterisations);
    }

    protected static Collection<String> getNames(Collection<VariableUsage> usages) {
        return usages.stream().map(VariableUsage::getNamedReference__VariableUsage).map(AbstractNamedReference::getReferenceName).collect(Collectors.toList());
    }

    protected static <T extends EObject> Optional<T> findParentOfType(EObject object, Class<T> clz) {
        EObject currentObject = object;
        while (currentObject != null && !clz.isInstance(currentObject)) {
            currentObject = currentObject.eContainer();
        }
        return Optional.ofNullable(currentObject);
    }

    protected static class AbstractActionOutputVariablesSwitch
    extends ComposedSwitch<Collection<String>> {
        public AbstractActionOutputVariablesSwitch() {
            super(Arrays.asList(new Switch[]{new AbstractActionOutputVariablesSwitchPCM(), new AbstractActionOutputVariablesSwitchIndirections()}));
        }

        public Collection<String> defaultCase(EObject eObject) {
            return Collections.emptyList();
        }
    }

    protected static class AbstractActionOutputVariablesSwitchIndirections
    extends ActionsSwitch<Collection<String>> {
        protected AbstractActionOutputVariablesSwitchIndirections() {
        }

        public Collection<String> caseConsumeDataAction(ConsumeDataAction object) {
            return Optional.ofNullable(object.getVariableReference()).map(AbstractNamedReference::getReferenceName).map(string -> Arrays.asList(string)).orElse(Collections.emptyList());
        }

        public Collection<String> caseCreateDateAction(CreateDateAction object) {
            return CreateVariableCharacterisationsViaEditor.getNames((Collection<VariableUsage>)object.getVariableUsages());
        }
    }

    protected static class AbstractActionOutputVariablesSwitchPCM
    extends SeffSwitch<Collection<String>> {
        protected AbstractActionOutputVariablesSwitchPCM() {
        }

        public Collection<String> caseExternalCallAction(ExternalCallAction object) {
            return CreateVariableCharacterisationsViaEditor.getNames((Collection<VariableUsage>)object.getReturnVariableUsage__CallReturnAction());
        }

        public Collection<String> caseSetVariableAction(SetVariableAction object) {
            return CreateVariableCharacterisationsViaEditor.getNames((Collection<VariableUsage>)object.getLocalVariableUsages_SetVariableAction());
        }
    }

    protected static class AbstractActionPredecessorIterator
    implements Iterator<AbstractAction> {
        protected static final PredecessorSwitch PREDECESSOR_SWITCH = new PredecessorSwitch();
        protected final Queue<AbstractAction> queue = new LinkedList<AbstractAction>();

        public AbstractActionPredecessorIterator(AbstractAction startingPoint) {
            this.queue.add(startingPoint);
            this.next();
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public AbstractAction next() {
            AbstractAction next = this.queue.poll();
            this.queue.addAll((Collection<AbstractAction>)PREDECESSOR_SWITCH.doSwitch((EObject)next));
            return next;
        }

        protected static class PredecessorSwitch
        extends SeffSwitch<Collection<AbstractAction>> {
            protected PredecessorSwitch() {
            }

            public Collection<AbstractAction> caseAbstractAction(AbstractAction object) {
                return Arrays.asList(object.getPredecessor_AbstractAction());
            }

            public Collection<AbstractAction> caseAbstractLoopAction(AbstractLoopAction object) {
                StopAction innerStopAction = PredecessorSwitch.findStopAction((Collection<AbstractAction>)object.getBodyBehaviour_Loop().getSteps_Behaviour());
                return Arrays.asList(object.getPredecessor_AbstractAction(), innerStopAction);
            }

            public Collection<AbstractAction> caseBranchAction(BranchAction object) {
                ArrayList<AbstractAction> result = new ArrayList<AbstractAction>();
                result.add(object.getPredecessor_AbstractAction());
                object.getBranches_Branch().stream().map(AbstractBranchTransition::getBranchBehaviour_BranchTransition).map(ResourceDemandingBehaviour::getSteps_Behaviour).map(PredecessorSwitch::findStopAction).forEach(result::add);
                return result;
            }

            public Collection<AbstractAction> caseForkAction(ForkAction object) {
                ArrayList<AbstractAction> result = new ArrayList<AbstractAction>();
                result.add(object.getPredecessor_AbstractAction());
                object.getAsynchronousForkedBehaviours_ForkAction().stream().map(ResourceDemandingBehaviour::getSteps_Behaviour).map(PredecessorSwitch::findStopAction).forEach(result::add);
                return result;
            }

            public Collection<AbstractAction> caseStartAction(StartAction object) {
                return Collections.emptyList();
            }

            protected static StopAction findStopAction(Collection<AbstractAction> steps) {
                return steps.stream().filter(StopAction.class::isInstance).map(StopAction.class::cast).findFirst().get();
            }

            public Collection<AbstractAction> doSwitch(EObject eObject) {
                ArrayList<AbstractAction> result = new ArrayList<AbstractAction>(Optional.ofNullable((Collection)super.doSwitch(eObject)).orElse(Collections.emptyList()));
                result.removeIf(Objects::isNull);
                return result;
            }
        }
    }

    protected static class AbstractUserActionOutputVariablesSwitch
    extends UsagemodelSwitch<Collection<String>> {
        protected AbstractUserActionOutputVariablesSwitch() {
        }

        public Collection<String> caseEntryLevelSystemCall(EntryLevelSystemCall object) {
            return CreateVariableCharacterisationsViaEditor.getNames((Collection<VariableUsage>)object.getOutputParameterUsages_EntryLevelSystemCall());
        }

        public Collection<String> defaultCase(EObject object) {
            return Collections.emptyList();
        }
    }

    protected static class AbstractUserActionPredecessorIterator
    implements Iterator<AbstractUserAction> {
        protected static final PredecessorSwitch PREDECESSOR_SWITCH = new PredecessorSwitch();
        protected final Queue<AbstractUserAction> queue = new LinkedList<AbstractUserAction>();

        public AbstractUserActionPredecessorIterator(AbstractUserAction startingPoint) {
            this.queue.add(startingPoint);
            this.next();
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public AbstractUserAction next() {
            AbstractUserAction next = this.queue.poll();
            this.queue.addAll((Collection<AbstractUserAction>)PREDECESSOR_SWITCH.doSwitch((EObject)next));
            return next;
        }

        protected static class PredecessorSwitch
        extends UsagemodelSwitch<Collection<AbstractUserAction>> {
            protected PredecessorSwitch() {
            }

            public Collection<AbstractUserAction> caseAbstractUserAction(AbstractUserAction object) {
                return Arrays.asList(object.getPredecessor());
            }

            public Collection<AbstractUserAction> caseBranch(Branch object) {
                ArrayList<AbstractUserAction> result = new ArrayList<AbstractUserAction>();
                result.add(object.getPredecessor());
                object.getBranchTransitions_Branch().stream().map(BranchTransition::getBranchedBehaviour_BranchTransition).map(ScenarioBehaviour::getActions_ScenarioBehaviour).map(PredecessorSwitch::findStop).forEach(result::add);
                return result;
            }

            public Collection<AbstractUserAction> caseLoop(Loop object) {
                ArrayList<AbstractUserAction> result = new ArrayList<AbstractUserAction>();
                result.add(object.getPredecessor());
                result.add((AbstractUserAction)PredecessorSwitch.findStop((Collection<AbstractUserAction>)object.getBodyBehaviour_Loop().getActions_ScenarioBehaviour()));
                return result;
            }

            public Collection<AbstractUserAction> caseStart(Start object) {
                return Collections.emptyList();
            }

            public Collection<AbstractUserAction> defaultCase(EObject object) {
                return Collections.emptyList();
            }

            protected static Stop findStop(Collection<AbstractUserAction> steps) {
                return steps.stream().filter(Stop.class::isInstance).map(Stop.class::cast).findFirst().get();
            }

            public Collection<AbstractUserAction> doSwitch(EObject eObject) {
                ArrayList<AbstractUserAction> result = new ArrayList<AbstractUserAction>(Optional.ofNullable((Collection)super.doSwitch(eObject)).orElse(Collections.emptyList()));
                result.removeIf(Objects::isNull);
                return result;
            }
        }
    }
}

