/**
 */
package org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour;

import org.eclipse.emf.common.util.EList;

import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;

import org.palladiosimulator.pcm.core.entity.Entity;

import org.palladiosimulator.pcm.parameter.VariableUsage;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Data Channel Behaviour</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.DataChannelBehaviour#getDataChannel <em>Data Channel</em>}</li>
 *   <li>{@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.DataChannelBehaviour#getDataSources <em>Data Sources</em>}</li>
 *   <li>{@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.DataChannelBehaviour#getDataSinks <em>Data Sinks</em>}</li>
 *   <li>{@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.DataChannelBehaviour#getVariableUsages <em>Variable Usages</em>}</li>
 *   <li>{@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.DataChannelBehaviour#getReusedBehaviours <em>Reused Behaviours</em>}</li>
 * </ul>
 *
 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourPackage#getDataChannelBehaviour()
 * @model annotation="http://www.eclipse.org/emf/2002/Ecore constraints='variableUsagesReferToValidSourceRoleParameter variableReferencesReferToValidSinkRoleParameter reusedBehavioursOnlyBindValidVariables'"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore/OCL/LPG variableUsagesReferToValidSourceRoleParameter='self.variableUsages-&gt;forAll(usage |\n\tself.dataSources-&gt;collect(\n\t\trole | role.entityName.concat(\'.\').concat(role.dataInterface.dataSignature.parameter.parameterName)\t\t\n\t)-&gt;includes(usage.namedReference__VariableUsage.referenceName)\n)' variableReferencesReferToValidSinkRoleParameter='self.variableUsages.variableCharacterisation_VariableUsage-&gt;selectByKind(confidentiality::ConfidentialityVariableCharacterisation)-&gt;forAll(characterisation |\n\tcharacterisation.rhs.oclAsType(ecore::EObject)-&gt;closure(eContents()-&gt;selectByKind(ecore::EObject))-&gt;selectByKind(stoex::VariableReference)-&gt;forAll(reference |\n\t\tself.dataSinks-&gt;collect(\n\t\t\trole | role.entityName.concat(\'.\').concat(role.dataInterface.dataSignature.parameter.parameterName)\n\t\t)-&gt;includes(reference.referenceName)\n\t)\n)' reusedBehavioursOnlyBindValidVariables='let validSourceNames : Set(String) = self.dataSources-&gt;collect(\n\trole | role.entityName.concat(\'.\').concat(role.dataInterface.dataSignature.parameter.parameterName)\n)-&gt;asSet() in\n\n    let validSinkNames : Set(String) = self.dataSinks-&gt;collect(\n        role | role.entityName.concat(\'.\').concat(role.dataInterface.dataSignature.parameter.parameterName)\n    )-&gt;asSet() in\n\n        let validReferenceNames : Set(String) = validSourceNames-&gt;union(validSinkNames) in\n\n            let usedReferenceNames : Set(String) = self.reusedBehaviours-&gt;collect(variableBindings)-&gt;flatten()-&gt;collect(boundValue.referenceName)-&gt;asSet() in\n\n                validReferenceNames-&gt;includesAll(usedReferenceNames)'"
 * @generated
 */
public interface DataChannelBehaviour extends Entity
{
	/**
	 * Returns the value of the '<em><b>Data Channel</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Data Channel</em>' reference.
	 * @see #setDataChannel(DataChannel)
	 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourPackage#getDataChannelBehaviour_DataChannel()
	 * @model required="true"
	 * @generated
	 */
	DataChannel getDataChannel();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.DataChannelBehaviour#getDataChannel <em>Data Channel</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Data Channel</em>' reference.
	 * @see #getDataChannel()
	 * @generated
	 */
	void setDataChannel(DataChannel value);

	/**
	 * Returns the value of the '<em><b>Data Sources</b></em>' reference list.
	 * The list contents are of type {@link org.palladiosimulator.indirections.repository.DataSourceRole}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Data Sources</em>' reference list.
	 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourPackage#getDataChannelBehaviour_DataSources()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 *        annotation="http://www.eclipse.org/emf/2002/Ecore/OCL/LPG derivation='self.dataChannel.dataSourceRoles'"
	 * @generated
	 */
	EList<DataSourceRole> getDataSources();

	/**
	 * Returns the value of the '<em><b>Data Sinks</b></em>' reference list.
	 * The list contents are of type {@link org.palladiosimulator.indirections.repository.DataSinkRole}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Data Sinks</em>' reference list.
	 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourPackage#getDataChannelBehaviour_DataSinks()
	 * @model transient="true" changeable="false" volatile="true" derived="true"
	 *        annotation="http://www.eclipse.org/emf/2002/Ecore/OCL/LPG derivation='self.dataChannel.dataSinkRoles'"
	 * @generated
	 */
	EList<DataSinkRole> getDataSinks();

	/**
	 * Returns the value of the '<em><b>Variable Usages</b></em>' containment reference list.
	 * The list contents are of type {@link org.palladiosimulator.pcm.parameter.VariableUsage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Variable Usages</em>' containment reference list.
	 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourPackage#getDataChannelBehaviour_VariableUsages()
	 * @model containment="true"
	 * @generated
	 */
	EList<VariableUsage> getVariableUsages();

	/**
	 * Returns the value of the '<em><b>Reused Behaviours</b></em>' containment reference list.
	 * The list contents are of type {@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourReuse}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reused Behaviours</em>' containment reference list.
	 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourPackage#getDataChannelBehaviour_ReusedBehaviours()
	 * @model containment="true"
	 * @generated
	 */
	EList<BehaviourReuse> getReusedBehaviours();

} // DataChannelBehaviour
