/**
 */
package org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.util;

import de.uka.ipd.sdq.identifier.util.IdentifierValidator;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour.BehaviourPackage
 * @generated
 */
public class BehaviourValidator extends EObjectValidator
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final BehaviourValidator INSTANCE = new BehaviourValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.behaviour";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BehaviourValidator()
	{
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage()
	{
	  return BehaviourPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		switch (classifierID)
		{
			case BehaviourPackage.DATA_CHANNEL_BEHAVIOUR:
				return validateDataChannelBehaviour((DataChannelBehaviour)value, diagnostics, context);
			case BehaviourPackage.BEHAVIOURS:
				return validateBehaviours((Behaviours)value, diagnostics, context);
			case BehaviourPackage.REUSABLE_BEHAVIOUR:
				return validateReusableBehaviour((ReusableBehaviour)value, diagnostics, context);
			case BehaviourPackage.BEHAVIOUR_REUSE:
				return validateBehaviourReuse((BehaviourReuse)value, diagnostics, context);
			case BehaviourPackage.VARIABLE_BINDING:
				return validateVariableBinding((VariableBinding)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataChannelBehaviour(DataChannelBehaviour dataChannelBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(dataChannelBehaviour, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataChannelBehaviour_variableUsagesReferToValidSourceRoleParameter(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataChannelBehaviour_variableReferencesReferToValidSinkRoleParameter(dataChannelBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataChannelBehaviour_reusedBehavioursOnlyBindValidVariables(dataChannelBehaviour, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the variableUsagesReferToValidSourceRoleParameter constraint of '<em>Data Channel Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_CHANNEL_BEHAVIOUR__VARIABLE_USAGES_REFER_TO_VALID_SOURCE_ROLE_PARAMETER__EEXPRESSION = "self.variableUsages->forAll(usage |\n" +
		"\tself.dataSources->collect(\n" +
		"\t\trole | role.entityName.concat('.').concat(role.dataInterface.dataSignature.parameter.parameterName)\t\t\n" +
		"\t)->includes(usage.namedReference__VariableUsage.referenceName)\n" +
		")";

	/**
	 * Validates the variableUsagesReferToValidSourceRoleParameter constraint of '<em>Data Channel Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataChannelBehaviour_variableUsagesReferToValidSourceRoleParameter(DataChannelBehaviour dataChannelBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(BehaviourPackage.Literals.DATA_CHANNEL_BEHAVIOUR,
				 dataChannelBehaviour,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "variableUsagesReferToValidSourceRoleParameter",
				 DATA_CHANNEL_BEHAVIOUR__VARIABLE_USAGES_REFER_TO_VALID_SOURCE_ROLE_PARAMETER__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the variableReferencesReferToValidSinkRoleParameter constraint of '<em>Data Channel Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_CHANNEL_BEHAVIOUR__VARIABLE_REFERENCES_REFER_TO_VALID_SINK_ROLE_PARAMETER__EEXPRESSION = "self.variableUsages.variableCharacterisation_VariableUsage->selectByKind(confidentiality::ConfidentialityVariableCharacterisation)->forAll(characterisation |\n" +
		"\tcharacterisation.rhs.oclAsType(ecore::EObject)->closure(eContents()->selectByKind(ecore::EObject))->selectByKind(stoex::VariableReference)->forAll(reference |\n" +
		"\t\tself.dataSinks->collect(\n" +
		"\t\t\trole | role.entityName.concat('.').concat(role.dataInterface.dataSignature.parameter.parameterName)\n" +
		"\t\t)->includes(reference.referenceName)\n" +
		"\t)\n" +
		")";

	/**
	 * Validates the variableReferencesReferToValidSinkRoleParameter constraint of '<em>Data Channel Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataChannelBehaviour_variableReferencesReferToValidSinkRoleParameter(DataChannelBehaviour dataChannelBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(BehaviourPackage.Literals.DATA_CHANNEL_BEHAVIOUR,
				 dataChannelBehaviour,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "variableReferencesReferToValidSinkRoleParameter",
				 DATA_CHANNEL_BEHAVIOUR__VARIABLE_REFERENCES_REFER_TO_VALID_SINK_ROLE_PARAMETER__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the reusedBehavioursOnlyBindValidVariables constraint of '<em>Data Channel Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_CHANNEL_BEHAVIOUR__REUSED_BEHAVIOURS_ONLY_BIND_VALID_VARIABLES__EEXPRESSION = "let validSourceNames : Set(String) = self.dataSources->collect(\n" +
		"\trole | role.entityName.concat('.').concat(role.dataInterface.dataSignature.parameter.parameterName)\n" +
		")->asSet() in\n" +
		"\n" +
		"    let validSinkNames : Set(String) = self.dataSinks->collect(\n" +
		"        role | role.entityName.concat('.').concat(role.dataInterface.dataSignature.parameter.parameterName)\n" +
		"    )->asSet() in\n" +
		"\n" +
		"        let validReferenceNames : Set(String) = validSourceNames->union(validSinkNames) in\n" +
		"\n" +
		"            let usedReferenceNames : Set(String) = self.reusedBehaviours->collect(variableBindings)->flatten()->collect(boundValue.referenceName)->asSet() in\n" +
		"\n" +
		"                validReferenceNames->includesAll(usedReferenceNames)";

	/**
	 * Validates the reusedBehavioursOnlyBindValidVariables constraint of '<em>Data Channel Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataChannelBehaviour_reusedBehavioursOnlyBindValidVariables(DataChannelBehaviour dataChannelBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(BehaviourPackage.Literals.DATA_CHANNEL_BEHAVIOUR,
				 dataChannelBehaviour,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "reusedBehavioursOnlyBindValidVariables",
				 DATA_CHANNEL_BEHAVIOUR__REUSED_BEHAVIOURS_ONLY_BIND_VALID_VARIABLES__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBehaviours(Behaviours behaviours, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)behaviours, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)behaviours, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)behaviours, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)behaviours, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)behaviours, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)behaviours, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)behaviours, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)behaviours, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)behaviours, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(behaviours, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateReusableBehaviour(ReusableBehaviour reusableBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(reusableBehaviour, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(reusableBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(reusableBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(reusableBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(reusableBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(reusableBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(reusableBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(reusableBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(reusableBehaviour, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(reusableBehaviour, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBehaviourReuse(BehaviourReuse behaviourReuse, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)behaviourReuse, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)behaviourReuse, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)behaviourReuse, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)behaviourReuse, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)behaviourReuse, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)behaviourReuse, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)behaviourReuse, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)behaviourReuse, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)behaviourReuse, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(behaviourReuse, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateVariableBinding(VariableBinding variableBinding, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)variableBinding, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(variableBinding, diagnostics, context);
		if (result || diagnostics != null) result &= validateVariableBinding_boundVariableBelongsToReusedBehaviour(variableBinding, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the boundVariableBelongsToReusedBehaviour constraint of '<em>Variable Binding</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String VARIABLE_BINDING__BOUND_VARIABLE_BELONGS_TO_REUSED_BEHAVIOUR__EEXPRESSION = "let reusedBehaviour : ReusableBehaviour = self.oclAsType(ecore::EObject).eContainer().oclAsType(BehaviourReuse).reusedBehaviour in\n" +
		"\treusedBehaviour.outputVariables->union(reusedBehaviour.inputVariables)->includes(self.boundVariable)";

	/**
	 * Validates the boundVariableBelongsToReusedBehaviour constraint of '<em>Variable Binding</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateVariableBinding_boundVariableBelongsToReusedBehaviour(VariableBinding variableBinding, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(BehaviourPackage.Literals.VARIABLE_BINDING,
				 (EObject)variableBinding,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "boundVariableBelongsToReusedBehaviour",
				 VARIABLE_BINDING__BOUND_VARIABLE_BELONGS_TO_REUSED_BEHAVIOUR__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator()
	{
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //BehaviourValidator
