/**
 */
package org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics;

import de.uka.ipd.sdq.identifier.Identifier;

import org.eclipse.emf.common.util.EList;

import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.CharacteristicType;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Enumeration;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Characteristic Type Dictionary</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Container for characteristic types and other entities required by these types. Characteristic types are required to define concrete characteristics that can be assign to entities, parameters or return values. For now, there is only support for finite-set value types, i.e. EnumCharacteristicType definitions.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.CharacteristicTypeDictionary#getCharacteristicTypes <em>Characteristic Types</em>}</li>
 *   <li>{@link org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.CharacteristicTypeDictionary#getCharacteristicEnumerations <em>Characteristic Enumerations</em>}</li>
 * </ul>
 *
 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.CharacteristicsPackage#getCharacteristicTypeDictionary()
 * @model
 * @generated
 */
public interface CharacteristicTypeDictionary extends Identifier
{
	/**
	 * Returns the value of the '<em><b>Characteristic Types</b></em>' containment reference list.
	 * The list contents are of type {@link org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.CharacteristicType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Available characteristic types.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Characteristic Types</em>' containment reference list.
	 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.CharacteristicsPackage#getCharacteristicTypeDictionary_CharacteristicTypes()
	 * @model containment="true"
	 * @generated
	 */
	EList<CharacteristicType> getCharacteristicTypes();

	/**
	 * Returns the value of the '<em><b>Characteristic Enumerations</b></em>' containment reference list.
	 * The list contents are of type {@link org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Enumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Enumerations that provide the value range for characteristic types.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Characteristic Enumerations</em>' containment reference list.
	 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.characteristics.CharacteristicsPackage#getCharacteristicTypeDictionary_CharacteristicEnumerations()
	 * @model containment="true"
	 * @generated
	 */
	EList<Enumeration> getCharacteristicEnumerations();

} // CharacteristicTypeDictionary
