/**
 */
package org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.repository.util;

import de.uka.ipd.sdq.identifier.util.IdentifierValidator;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.repository.*;

import org.palladiosimulator.pcm.core.entity.util.EntityValidator;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.repository.RepositoryPackage
 * @generated
 */
public class RepositoryValidator extends EObjectValidator
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final RepositoryValidator INSTANCE = new RepositoryValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.dataflow.confidentiality.pcm.model.confidentiality.repository";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EntityValidator entityValidator;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected org.palladiosimulator.pcm.repository.util.RepositoryValidator repositoryValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RepositoryValidator()
	{
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
		entityValidator = EntityValidator.INSTANCE;
		repositoryValidator = org.palladiosimulator.pcm.repository.util.RepositoryValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage()
	{
	  return RepositoryPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		switch (classifierID)
		{
			case RepositoryPackage.OPERATIONAL_DATA_STORE_COMPONENT:
				return validateOperationalDataStoreComponent((OperationalDataStoreComponent)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOperationalDataStoreComponent(OperationalDataStoreComponent operationalDataStoreComponent, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(operationalDataStoreComponent, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= entityValidator.validateInterfaceProvidingEntity_needID(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateImplementationComponentType_requiredInterfacesHaveToConformToCompleteType(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateImplementationComponentType_providedInterfacesHaveToConformToCompleteType(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateImplementationComponentType_providedInterfaceHaveToConformToComponentType(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateImplementationComponentType_provideSameOrMoreInterfacesAsCompleteComponentType(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateImplementationComponentType_requireSameOrFewerInterfacesAsCompleteComponentType(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateBasicComponent_noSeffTypeUsedTwice(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateBasicComponent_everyOperationInterfaceMethodsNeedsSEFF(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateBasicComponent_everyInfrastructureInterfaceMethodsNeedsSEFF(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateOperationalDataStoreComponent_onlyProvidesDataStoreInterface(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateOperationalDataStoreComponent_noRequiredInterfaces(operationalDataStoreComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateOperationalDataStoreComponent_allSeffsAreEmpty(operationalDataStoreComponent, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the onlyProvidesDataStoreInterface constraint of '<em>Operational Data Store Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String OPERATIONAL_DATA_STORE_COMPONENT__ONLY_PROVIDES_DATA_STORE_INTERFACE__EEXPRESSION = "self.providedRoles_InterfaceProvidingEntity->size() = 1 and\n" +
		"let opInterface : pcm::repository::OperationInterface = self.providedRoles_InterfaceProvidingEntity->selectByKind(pcm::repository::OperationProvidedRole).providedInterface__OperationProvidedRole->any(true) in\n" +
		"    opInterface.signatures__OperationInterface->size() = 2 and\n" +
		"    let addSignature : pcm::repository::OperationSignature = opInterface.signatures__OperationInterface->any(signature | signature.entityName.substring(1,3) = 'add') in\n" +
		"        addSignature.parameters__OperationSignature->size() = 1 and addSignature.returnType__OperationSignature.oclIsUndefined() and\n" +
		"        let getSignature : pcm::repository::OperationSignature = opInterface.signatures__OperationInterface->any(signature | signature.entityName.substring(1,3) = 'get') in\n" +
		"            getSignature.parameters__OperationSignature->size() = 0 and not getSignature.returnType__OperationSignature.oclIsUndefined() and\n" +
		"            addSignature.parameters__OperationSignature->any(true).dataType__Parameter = getSignature.returnType__OperationSignature";

	/**
	 * Validates the onlyProvidesDataStoreInterface constraint of '<em>Operational Data Store Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOperationalDataStoreComponent_onlyProvidesDataStoreInterface(OperationalDataStoreComponent operationalDataStoreComponent, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(RepositoryPackage.Literals.OPERATIONAL_DATA_STORE_COMPONENT,
				 operationalDataStoreComponent,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "onlyProvidesDataStoreInterface",
				 OPERATIONAL_DATA_STORE_COMPONENT__ONLY_PROVIDES_DATA_STORE_INTERFACE__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the noRequiredInterfaces constraint of '<em>Operational Data Store Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String OPERATIONAL_DATA_STORE_COMPONENT__NO_REQUIRED_INTERFACES__EEXPRESSION = "self.requiredRoles_InterfaceRequiringEntity->isEmpty()";

	/**
	 * Validates the noRequiredInterfaces constraint of '<em>Operational Data Store Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOperationalDataStoreComponent_noRequiredInterfaces(OperationalDataStoreComponent operationalDataStoreComponent, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(RepositoryPackage.Literals.OPERATIONAL_DATA_STORE_COMPONENT,
				 operationalDataStoreComponent,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "noRequiredInterfaces",
				 OPERATIONAL_DATA_STORE_COMPONENT__NO_REQUIRED_INTERFACES__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the allSeffsAreEmpty constraint of '<em>Operational Data Store Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String OPERATIONAL_DATA_STORE_COMPONENT__ALL_SEFFS_ARE_EMPTY__EEXPRESSION = "self.serviceEffectSpecifications__BasicComponent->selectByKind(pcm::seff::ResourceDemandingBehaviour)->forAll(seff | seff.steps_Behaviour->size() = 2)";

	/**
	 * Validates the allSeffsAreEmpty constraint of '<em>Operational Data Store Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOperationalDataStoreComponent_allSeffsAreEmpty(OperationalDataStoreComponent operationalDataStoreComponent, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(RepositoryPackage.Literals.OPERATIONAL_DATA_STORE_COMPONENT,
				 operationalDataStoreComponent,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "allSeffsAreEmpty",
				 OPERATIONAL_DATA_STORE_COMPONENT__ALL_SEFFS_ARE_EMPTY__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator()
	{
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //RepositoryValidator
