package org.palladiosimulator.dataflow.confidentiality.pcm.queryutils;

import java.util.Stack;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.palladiosimulator.indirections.actions.DataAction;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;

@Data
@SuppressWarnings("all")
public class DataActionWithContext implements OutgoingDataDestination {
  private final DataAction dataAction;

  private final DataSinkRole dataSinkRole;

  private final Stack<AssemblyContext> context;

  public DataActionWithContext(final DataAction dataAction, final DataSinkRole dataSinkRole, final Stack<AssemblyContext> context) {
    super();
    this.dataAction = dataAction;
    this.dataSinkRole = dataSinkRole;
    this.context = context;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.dataAction== null) ? 0 : this.dataAction.hashCode());
    result = prime * result + ((this.dataSinkRole== null) ? 0 : this.dataSinkRole.hashCode());
    return prime * result + ((this.context== null) ? 0 : this.context.hashCode());
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    DataActionWithContext other = (DataActionWithContext) obj;
    if (this.dataAction == null) {
      if (other.dataAction != null)
        return false;
    } else if (!this.dataAction.equals(other.dataAction))
      return false;
    if (this.dataSinkRole == null) {
      if (other.dataSinkRole != null)
        return false;
    } else if (!this.dataSinkRole.equals(other.dataSinkRole))
      return false;
    if (this.context == null) {
      if (other.context != null)
        return false;
    } else if (!this.context.equals(other.context))
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("dataAction", this.dataAction);
    b.add("dataSinkRole", this.dataSinkRole);
    b.add("context", this.context);
    return b.toString();
  }

  @Pure
  public DataAction getDataAction() {
    return this.dataAction;
  }

  @Pure
  public DataSinkRole getDataSinkRole() {
    return this.dataSinkRole;
  }

  @Pure
  public Stack<AssemblyContext> getContext() {
    return this.context;
  }
}
