package org.palladiosimulator.dataflow.confidentiality.pcm.queryutils;

import java.util.Stack;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;

@Data
@SuppressWarnings("all")
public class DataSinkRoleWithContext implements OutgoingDataDestination {
  private final DataChannel dataChannel;

  private final DataSinkRole dataSinkRole;

  private final Stack<AssemblyContext> context;

  public DataSinkRoleWithContext(final DataChannel dataChannel, final DataSinkRole dataSinkRole, final Stack<AssemblyContext> context) {
    super();
    this.dataChannel = dataChannel;
    this.dataSinkRole = dataSinkRole;
    this.context = context;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.dataChannel== null) ? 0 : this.dataChannel.hashCode());
    result = prime * result + ((this.dataSinkRole== null) ? 0 : this.dataSinkRole.hashCode());
    return prime * result + ((this.context== null) ? 0 : this.context.hashCode());
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    DataSinkRoleWithContext other = (DataSinkRoleWithContext) obj;
    if (this.dataChannel == null) {
      if (other.dataChannel != null)
        return false;
    } else if (!this.dataChannel.equals(other.dataChannel))
      return false;
    if (this.dataSinkRole == null) {
      if (other.dataSinkRole != null)
        return false;
    } else if (!this.dataSinkRole.equals(other.dataSinkRole))
      return false;
    if (this.context == null) {
      if (other.context != null)
        return false;
    } else if (!this.context.equals(other.context))
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("dataChannel", this.dataChannel);
    b.add("dataSinkRole", this.dataSinkRole);
    b.add("context", this.context);
    return b.toString();
  }

  @Pure
  public DataChannel getDataChannel() {
    return this.dataChannel;
  }

  @Pure
  public DataSinkRole getDataSinkRole() {
    return this.dataSinkRole;
  }

  @Pure
  public Stack<AssemblyContext> getContext() {
    return this.context;
  }
}
