package org.palladiosimulator.dataflow.confidentiality.pcm.queryutils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.indirections.actions.ConsumeDataAction;
import org.palladiosimulator.indirections.composition.AssemblyDataConnector;
import org.palladiosimulator.indirections.composition.DataSinkDelegationConnector;
import org.palladiosimulator.indirections.composition.DataSourceDelegationConnector;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.StopAction;

@SuppressWarnings("all")
public class PcmQueryUtils {
  @Extension
  private final ModelQueryUtils modelQueryUtils = new ModelQueryUtils();

  /**
   * Finds a called SEFF and the corresponding stack of assembly contexts.
   * It requires the context of the resolution process to be specified as stack of assembly contexts.
   * The resulting stack can be completely different to the stack from which the call originated
   * because composite components do not provide SEFFs but only contribute to the stack.
   * 
   * @param requiredRole The required role that points to the required component.
   * @param calledSignature The signature that the SEFF describes.
   * @param context The stack of assembly contexts that identifies the point from which
   *        the call shall be resolved. The list starts with the most outer assembly context.
   * @return A tuple of the resolved SEFF and the assembly context stack.
   */
  public SeffWithContext findCalledSeff(final RequiredRole requiredRole, final Signature calledSignature, final Stack<AssemblyContext> contexts) {
    SeffWithContext _xblockexpression = null;
    {
      final ComposedStructure composedStructure = IterableExtensions.<AssemblyContext>last(contexts).getParentStructure__AssemblyContext();
      final Stack<AssemblyContext> newcontext = new Stack<AssemblyContext>();
      Iterables.<AssemblyContext>addAll(newcontext, contexts);
      final Function1<AssemblyConnector, Boolean> _function = (AssemblyConnector it) -> {
        return Boolean.valueOf(((it.getRequiredRole_AssemblyConnector() == requiredRole) && 
          (it.getRequiringAssemblyContext_AssemblyConnector() == IterableExtensions.<AssemblyContext>last(newcontext))));
      };
      final AssemblyConnector assemblyConnector = IterableExtensions.<AssemblyConnector>findFirst(Iterables.<AssemblyConnector>filter(composedStructure.getConnectors__ComposedStructure(), AssemblyConnector.class), _function);
      if ((assemblyConnector != null)) {
        newcontext.remove(IterableExtensions.<AssemblyContext>last(newcontext));
        final AssemblyContext newAssemblyContext = assemblyConnector.getProvidingAssemblyContext_AssemblyConnector();
        final OperationProvidedRole providedRole = assemblyConnector.getProvidedRole_AssemblyConnector();
        newcontext.add(newAssemblyContext);
        return this.findCalledSeff(providedRole, calledSignature, newcontext);
      }
      final Function1<RequiredDelegationConnector, Boolean> _function_1 = (RequiredDelegationConnector it) -> {
        OperationRequiredRole _innerRequiredRole_RequiredDelegationConnector = it.getInnerRequiredRole_RequiredDelegationConnector();
        return Boolean.valueOf(Objects.equal(_innerRequiredRole_RequiredDelegationConnector, requiredRole));
      };
      final Function1<RequiredDelegationConnector, OperationRequiredRole> _function_2 = (RequiredDelegationConnector it) -> {
        return it.getOuterRequiredRole_RequiredDelegationConnector();
      };
      final OperationRequiredRole outerRequiredRole = IterableExtensions.<OperationRequiredRole>head(IterableExtensions.<RequiredDelegationConnector, OperationRequiredRole>map(IterableExtensions.<RequiredDelegationConnector>filter(Iterables.<RequiredDelegationConnector>filter(composedStructure.getConnectors__ComposedStructure(), RequiredDelegationConnector.class), _function_1), _function_2));
      newcontext.remove(IterableExtensions.<AssemblyContext>last(newcontext));
      _xblockexpression = this.findCalledSeff(outerRequiredRole, calledSignature, newcontext);
    }
    return _xblockexpression;
  }

  /**
   * Finds a called SEFF and the corresponding stack of assembly contexts.
   * It requires the context of the resolution process to be specified as stack of assembly contexts.
   * The resulting stack can be completely different to the stack from which the call originated
   * because composite components do not provide SEFFs but only contribute to the stack.
   * 
   * @param providedRole The provided role that points to the identifying component.
   * @param calledSignature The signature that the SEFF describes.
   * @param context The stack of assembly contexts that identifies the point from which
   *        the call shall be resolved. The list starts with the most outer assembly context.
   * @return A tuple of the resolved SEFF and the assembly context stack.
   */
  public SeffWithContext findCalledSeff(final ProvidedRole providedRole, final Signature calledSignature, final Stack<AssemblyContext> context) {
    final Stack<AssemblyContext> newContexts = new Stack<AssemblyContext>();
    Iterables.<AssemblyContext>addAll(newContexts, context);
    ProvidedRole role = providedRole;
    InterfaceProvidingEntity providingComponent = role.getProvidingEntity_ProvidedRole();
    while ((providingComponent instanceof ComposedStructure)) {
      {
        final ProvidedDelegationConnector connector = this.findProvidedDelegationConnector(((ComposedStructure)providingComponent), role);
        final AssemblyContext assemblyContext = connector.getAssemblyContext_ProvidedDelegationConnector();
        newContexts.add(assemblyContext);
        role = connector.getInnerProvidedRole_ProvidedDelegationConnector();
        providingComponent = role.getProvidingEntity_ProvidedRole();
      }
    }
    if ((providingComponent instanceof BasicComponent)) {
      final Function1<ResourceDemandingSEFF, Boolean> _function = (ResourceDemandingSEFF it) -> {
        Signature _describedService__SEFF = it.getDescribedService__SEFF();
        return Boolean.valueOf(Objects.equal(_describedService__SEFF, calledSignature));
      };
      final ResourceDemandingSEFF seff = IterableExtensions.<ResourceDemandingSEFF>findFirst(Iterables.<ResourceDemandingSEFF>filter(((BasicComponent)providingComponent).getServiceEffectSpecifications__BasicComponent(), ResourceDemandingSEFF.class), _function);
      if ((seff == null)) {
        return null;
      }
      return new SeffWithContext(seff, newContexts);
    }
    return null;
  }

  protected ProvidedDelegationConnector findProvidedDelegationConnector(final ComposedStructure component, final ProvidedRole outerRole) {
    final Function1<ProvidedDelegationConnector, Boolean> _function = (ProvidedDelegationConnector it) -> {
      OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = it.getOuterProvidedRole_ProvidedDelegationConnector();
      return Boolean.valueOf(Objects.equal(_outerProvidedRole_ProvidedDelegationConnector, outerRole));
    };
    return IterableExtensions.<ProvidedDelegationConnector>findFirst(Iterables.<ProvidedDelegationConnector>filter(component.getConnectors__ComposedStructure(), ProvidedDelegationConnector.class), _function);
  }

  public StopAction getStopAction(final ResourceDemandingSEFF seff) {
    final Function1<StopAction, Boolean> _function = (StopAction it) -> {
      return Boolean.valueOf(true);
    };
    return IterableExtensions.<StopAction>findFirst(Iterables.<StopAction>filter(seff.getSteps_Behaviour(), StopAction.class), _function);
  }

  public Iterable<OutgoingDataDestination> findDestinations(final DataSourceRole emittingRole, final Stack<AssemblyContext> context) {
    ArrayList<OutgoingDataDestination> _xblockexpression = null;
    {
      final ArrayList<OutgoingDataDestination> result = new ArrayList<OutgoingDataDestination>();
      final AssemblyContext emittingAc = context.peek();
      final ComposedStructure parent = emittingAc.getParentStructure__AssemblyContext();
      final Stack<AssemblyContext> newStack = this.<AssemblyContext>copy(context);
      newStack.pop();
      final Function1<DataSourceDelegationConnector, Boolean> _function = (DataSourceDelegationConnector it) -> {
        return Boolean.valueOf(((it.getInnerDataSourceRole() == emittingRole) && (it.getAssemblyContext() == emittingAc)));
      };
      final Iterable<DataSourceDelegationConnector> delegationConnectors = IterableExtensions.<DataSourceDelegationConnector>filter(Iterables.<DataSourceDelegationConnector>filter(parent.getConnectors__ComposedStructure(), DataSourceDelegationConnector.class), _function);
      for (final DataSourceDelegationConnector delegationConnector : delegationConnectors) {
        Iterable<OutgoingDataDestination> _findDestinations = this.findDestinations(delegationConnector.getOuterDataSourceRole(), newStack);
        Iterables.<OutgoingDataDestination>addAll(result, _findDestinations);
      }
      final Function1<AssemblyDataConnector, Boolean> _function_1 = (AssemblyDataConnector it) -> {
        return Boolean.valueOf(((it.getDataSourceRole() == emittingRole) && (it.getSourceAssemblyContext() == emittingAc)));
      };
      final Iterable<AssemblyDataConnector> assemblyConnectors = IterableExtensions.<AssemblyDataConnector>filter(Iterables.<AssemblyDataConnector>filter(parent.getConnectors__ComposedStructure(), AssemblyDataConnector.class), _function_1);
      for (final AssemblyDataConnector assemblyConnector : assemblyConnectors) {
        Iterable<OutgoingDataDestination> _findDestinations_1 = this.findDestinations(assemblyConnector, newStack);
        Iterables.<OutgoingDataDestination>addAll(result, _findDestinations_1);
      }
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  protected Iterable<OutgoingDataDestination> findDestinations(final AssemblyDataConnector connector, final Stack<AssemblyContext> context) {
    final AssemblyContext sinkAc = connector.getSinkAssemblyContext();
    final DataSinkRole sinkRole = connector.getDataSinkRole();
    final RepositoryComponent sinkComponent = sinkAc.getEncapsulatedComponent__AssemblyContext();
    final Stack<AssemblyContext> newStack = this.<AssemblyContext>copy(context);
    newStack.add(sinkAc);
    return this.findDestinations(sinkComponent, sinkRole, newStack);
  }

  protected Iterable<OutgoingDataDestination> findDestinations(final RepositoryComponent sinkComponent, final DataSinkRole sinkRole, final Stack<AssemblyContext> context) {
    ArrayList<OutgoingDataDestination> _xblockexpression = null;
    {
      final ArrayList<OutgoingDataDestination> result = new ArrayList<OutgoingDataDestination>();
      if ((sinkComponent instanceof CompositeComponent)) {
        final Function1<DataSinkDelegationConnector, Boolean> _function = (DataSinkDelegationConnector it) -> {
          DataSinkRole _outerDataSinkRole = it.getOuterDataSinkRole();
          return Boolean.valueOf((_outerDataSinkRole == sinkRole));
        };
        final Iterable<DataSinkDelegationConnector> delegationConnectors = IterableExtensions.<DataSinkDelegationConnector>filter(Iterables.<DataSinkDelegationConnector>filter(((CompositeComponent)sinkComponent).getConnectors__ComposedStructure(), DataSinkDelegationConnector.class), _function);
        for (final DataSinkDelegationConnector delegationConnector : delegationConnectors) {
          {
            final AssemblyContext innerAc = delegationConnector.getAssemblyContext();
            final RepositoryComponent innerComponent = innerAc.getEncapsulatedComponent__AssemblyContext();
            final DataSinkRole innerRole = delegationConnector.getInnerDataSinkRole();
            final Stack<AssemblyContext> newStack = this.<AssemblyContext>copy(context);
            newStack.add(innerAc);
            Iterable<OutgoingDataDestination> _findDestinations = this.findDestinations(innerComponent, innerRole, newStack);
            Iterables.<OutgoingDataDestination>addAll(result, _findDestinations);
          }
        }
      } else {
        if ((sinkComponent instanceof DataChannel)) {
          DataSinkRoleWithContext _dataSinkRoleWithContext = new DataSinkRoleWithContext(((DataChannel)sinkComponent), sinkRole, context);
          result.add(_dataSinkRoleWithContext);
        } else {
          if ((sinkComponent instanceof BasicComponent)) {
            final Iterable<AbstractAction> actions = this.modelQueryUtils.<AbstractAction>findChildrenOfType(sinkComponent, AbstractAction.class);
            final Function1<ConsumeDataAction, Boolean> _function_1 = (ConsumeDataAction it) -> {
              DataSinkRole _dataSinkRole = it.getDataSinkRole();
              return Boolean.valueOf((_dataSinkRole == sinkRole));
            };
            final Function1<ConsumeDataAction, DataActionWithContext> _function_2 = (ConsumeDataAction da) -> {
              return new DataActionWithContext(da, sinkRole, context);
            };
            final Iterable<DataActionWithContext> consumeActions = IterableExtensions.<ConsumeDataAction, DataActionWithContext>map(IterableExtensions.<ConsumeDataAction>filter(Iterables.<ConsumeDataAction>filter(actions, ConsumeDataAction.class), _function_1), _function_2);
            Iterables.<OutgoingDataDestination>addAll(result, consumeActions);
          }
        }
      }
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  protected <T extends Object> Stack<T> copy(final Stack<T> stack) {
    Stack<T> _xblockexpression = null;
    {
      final Stack<T> copy = new Stack<T>();
      copy.addAll(stack);
      _xblockexpression = copy;
    }
    return _xblockexpression;
  }
}
