package org.palladiosimulator.dataflow.confidentiality.pcm.queryutils;

import java.util.Stack;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;

@Data
@SuppressWarnings("all")
public class SeffWithContext {
  private final ResourceDemandingSEFF seff;

  private final Stack<AssemblyContext> context;

  public SeffWithContext(final ResourceDemandingSEFF seff, final Stack<AssemblyContext> context) {
    super();
    this.seff = seff;
    this.context = context;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.seff== null) ? 0 : this.seff.hashCode());
    return prime * result + ((this.context== null) ? 0 : this.context.hashCode());
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    SeffWithContext other = (SeffWithContext) obj;
    if (this.seff == null) {
      if (other.seff != null)
        return false;
    } else if (!this.seff.equals(other.seff))
      return false;
    if (this.context == null) {
      if (other.context != null)
        return false;
    } else if (!this.context.equals(other.context))
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("seff", this.seff);
    b.add("context", this.context);
    return b.toString();
  }

  @Pure
  public ResourceDemandingSEFF getSeff() {
    return this.seff;
  }

  @Pure
  public Stack<AssemblyContext> getContext() {
    return this.context;
  }
}
