/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dataflow.confidentiality.ui.wizard;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.session.UserSession;

public final class SiriusUtils {
    private SiriusUtils() {
    }

    public static Session createSession(IProject project, IProgressMonitor monitor) {
        URI sessionResourceURI = URI.createPlatformResourceURI((String)("/" + project.getName() + "/" + "representations.aird"), (boolean)true);
        Session session = SessionManager.INSTANCE.getSession(sessionResourceURI, monitor);
        return session;
    }

    public static void addSemanticResource(Session session, URI resourceUri, IProgressMonitor monitor) {
        TransactionalEditingDomain ted = session.getTransactionalEditingDomain();
        ted.getCommandStack().execute((Command)new AddSemanticResourceCommand(session, resourceUri, monitor));
    }

    public static UserSession enableViewpoint(Session session, String viewpointName) {
        return SiriusUtils.enableViewpoints(session, Arrays.asList(viewpointName));
    }

    public static UserSession enableViewpoints(Session session, Iterable<String> viewpointNames) {
        UserSession userSession = UserSession.from((Session)session);
        return userSession.selectViewpoints(viewpointNames);
    }
}

