/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dataflow.confidentiality.ui.wizard;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.util.StringInputStream;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.DataDictionaryCharacterized;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.DataDictionaryCharacterizedFactory;
import org.palladiosimulator.dataflow.dictionary.characterized.dsl.ui.internal.DslActivator;

public final class WizardUtils {
    private WizardUtils() {
    }

    public static void addXtextNature(IProject newProject, IProgressMonitor monitor) throws CoreException {
        if (!XtextProjectHelper.hasNature((IProject)newProject)) {
            IProjectDescription projectDescription = newProject.getDescription();
            String[] newNatureIds = Arrays.copyOf(projectDescription.getNatureIds(), projectDescription.getNatureIds().length + 1);
            newNatureIds[newNatureIds.length - 1] = "org.eclipse.xtext.ui.shared.xtextNature";
            projectDescription.setNatureIds(newNatureIds);
            newProject.setDescription(projectDescription, monitor);
        }
    }

    public static void createDataDictionary(IFile destinationFile, IProgressMonitor monitor) throws CoreException {
        Injector injector = DslActivator.getInstance().getInjector("org.palladiosimulator.dataflow.dictionary.characterized.dsl.CharacterizedDataDictionary");
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        DataDictionaryCharacterized emptyDictionary = DataDictionaryCharacterizedFactory.eINSTANCE.createDataDictionaryCharacterized();
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)("virtual:/tmp/foo." + destinationFile.getFileExtension())));
        r.getContents().add((Object)emptyDictionary);
        String fileContent = serializer.serialize((EObject)emptyDictionary);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (StringInputStream sis = new StringInputStream(fileContent);){
                destinationFile.create((InputStream)sis, true, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, WizardUtils.class, "Could not create file.", (Throwable)e));
        }
    }

    public static void openEditor(IWorkbench workbench, IFile file) throws PartInitException {
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
    }
}

