/*
 * generated by Xtext 2.23.0
 */
package org.palladiosimulator.dataflow.dictionary.characterized.dsl.generator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
public class CharacterizedDataDictionaryGenerator extends AbstractGenerator {

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            createXMIVersionOfResource(resource, fsa);
        } catch (IOException e) {
            // do nothing
        }
    }

    protected void createXMIVersionOfResource(Resource resource, IFileSystemAccess2 fsa) throws IOException {
        var tmpUri = resource.getURI()
            .trimSegments(1)
            .appendSegment(UUID.randomUUID()
                .toString() + ".xmi");
        var tmpResource = resource.getResourceSet()
            .createResource(tmpUri);
        try {
            tmpResource.getContents()
                .addAll(resource.getContents()
                    .stream()
                    .map(EcoreUtil::copy)
                    .collect(Collectors.toList()));
            var tmpOutput = new ByteArrayOutputStream();
            tmpResource.save(tmpOutput, Collections.emptyMap());
            var fileName = resource.getURI()
                .trimFileExtension()
                .lastSegment() + ".xmi";
            fsa.generateFile(fileName, tmpOutput.toString());
        } finally {
            tmpResource.delete(Collections.emptyMap());
        }
    }
}
