/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dataflow.dictionary.characterized.dsl.scoping;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Assignment;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.BehaviorDefinition;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.DataDictionaryCharacterizedPackage;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Entity;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.EnumCharacteristic;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.EnumCharacteristicType;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Enumeration;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.Literal;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.expressions.CharacteristicReference;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.expressions.DataCharacteristicReference;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.expressions.EnumCharacteristicReference;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.expressions.ExpressionsPackage;
import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.expressions.Term;
import org.palladiosimulator.dataflow.dictionary.characterized.dsl.scoping.AbstractCharacterizedDataDictionaryScopeProvider;
import org.palladiosimulator.dataflow.dictionary.characterized.dsl.scoping.TransformingScope;

public class CharacterizedDataDictionaryScopeProvider
extends AbstractCharacterizedDataDictionaryScopeProvider {
    protected final Collection<IScopeProcessor> scopeProcessors = this.initScopeProcessors();

    protected Collection<IScopeProcessor> initScopeProcessors() {
        ArrayList<IScopeProcessor> processors = new ArrayList<IScopeProcessor>();
        Method[] methodArray = CharacterizedDataDictionaryScopeProvider.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(IScopeProcessorMethod.class) != null) {
                Class<IScopeProcessor> functionalInterface = IScopeProcessor.class;
                Method functionalInterfaceMethod = functionalInterface.getMethods()[0];
                String functionalInterfaceMethodName = functionalInterfaceMethod.getName();
                MethodType functionalInterfaceMethodType = MethodType.methodType(functionalInterfaceMethod.getReturnType(), functionalInterfaceMethod.getParameterTypes());
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                try {
                    MethodHandle handle = lookup.unreflect(method);
                    CallSite callSite = LambdaMetafactory.metafactory(lookup, functionalInterfaceMethodName, MethodType.methodType(functionalInterface, CharacterizedDataDictionaryScopeProvider.class), functionalInterfaceMethodType, handle, functionalInterfaceMethodType);
                    IScopeProcessor processor = callSite.getTarget().bindTo((Object)this).invoke();
                    processors.add(processor);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return processors;
    }

    public IScope getScope(EObject context, EReference reference) {
        IScope currentScope = super.getScope(context, reference);
        for (IScopeProcessor processor : this.scopeProcessors) {
            currentScope = processor.apply(context, reference, currentScope);
        }
        return currentScope;
    }

    @IScopeProcessorMethod
    protected IScope getScopeForPinInDataCharacteristicReference(EObject context, EReference reference, IScope scope) {
        if (reference != ExpressionsPackage.Literals.DATA_CHARACTERISTIC_REFERENCE__PIN) {
            return scope;
        }
        Optional<DataCharacteristicReference> characteristicReference = Optional.ofNullable(context).filter(DataCharacteristicReference.class::isInstance).map(DataCharacteristicReference.class::cast);
        Optional<BehaviorDefinition> behaviorDefinition = this.findParentOfType(context, BehaviorDefinition.class);
        ArrayList usablePins = new ArrayList();
        if (characteristicReference.map(this::isLhs).orElse(true).booleanValue()) {
            behaviorDefinition.map(BehaviorDefinition::getOutputs).ifPresent(usablePins::addAll);
        }
        if (characteristicReference.map(this::isRhs).orElse(true).booleanValue()) {
            behaviorDefinition.map(BehaviorDefinition::getInputs).ifPresent(usablePins::addAll);
        }
        return new FilteringScope(scope, description -> usablePins.contains(description.getEObjectOrProxy()));
    }

    @IScopeProcessorMethod
    protected IScope getScopeForLiteralInEnumCharacteristicReference(EObject context, EReference reference, IScope scope) {
        if (reference != ExpressionsPackage.Literals.ENUM_CHARACTERISTIC_REFERENCE__LITERAL) {
            return scope;
        }
        Optional<Enumeration> foundEnumeration = Optional.ofNullable(context).filter(EnumCharacteristicReference.class::isInstance).map(EnumCharacteristicReference.class::cast).map(CharacteristicReference::getCharacteristicType).filter(EnumCharacteristicType.class::isInstance).map(EnumCharacteristicType.class::cast).map(EnumCharacteristicType::getType);
        if (foundEnumeration.isEmpty()) {
            return scope;
        }
        Enumeration enumeration = foundEnumeration.get();
        String enumerationName = enumeration.getName();
        EList literals = enumeration.getLiterals();
        FilteringScope newScope = new FilteringScope(scope, description -> {
            Literal literal = (Literal)description.getEObjectOrProxy();
            if (!literals.isEmpty() && !literals.contains((Object)description.getEObjectOrProxy())) {
                if (!Optional.of(literal.getEnum()).map(Entity::getName).map(enumerationName::equals).orElse(false).booleanValue()) {
                    return false;
                }
            }
            return true;
        });
        return this.buildLastSegmentScope((IScope)newScope);
    }

    @IScopeProcessorMethod
    protected IScope getScopeForValuesInEnumCharacteristic(EObject context, EReference reference, IScope scope) {
        if (reference != DataDictionaryCharacterizedPackage.Literals.ENUM_CHARACTERISTIC__VALUES) {
            return scope;
        }
        EList literals = Optional.ofNullable(context).filter(EnumCharacteristic.class::isInstance).map(EnumCharacteristic.class::cast).map(EnumCharacteristic::getEnumCharacteristicType).map(EnumCharacteristicType::getType).map(Enumeration::getLiterals).orElse((EList)new BasicEList());
        if (literals.isEmpty()) {
            return scope;
        }
        FilteringScope filteredScope = new FilteringScope(scope, description -> literals.contains((Object)description.getEObjectOrProxy()));
        return this.buildLastSegmentScope((IScope)filteredScope);
    }

    protected IScope buildLastSegmentScope(IScope superScope) {
        return new TransformingScope(superScope, description -> Optional.ofNullable(description).map(d -> new AliasedEObjectDescription(QualifiedName.create((String)description.getQualifiedName().getLastSegment()), d)).orElse((IEObjectDescription)description));
    }

    protected <T extends EObject> Optional<T> findParentOfType(EObject object, Class<T> parentType) {
        EObject currentObject = object;
        while (currentObject != null) {
            if (parentType.isInstance(currentObject)) {
                return Optional.of(currentObject);
            }
            currentObject = currentObject.eContainer();
        }
        return Optional.empty();
    }

    protected boolean isLhs(CharacteristicReference reference) {
        Optional<Assignment> assignment = this.findParentOfType((EObject)reference, Assignment.class);
        if (!assignment.isPresent()) {
            return false;
        }
        return assignment.get().getLhs() == reference;
    }

    protected boolean isRhs(CharacteristicReference reference) {
        Optional<Assignment> assignment = this.findParentOfType((EObject)reference, Assignment.class);
        if (!assignment.isPresent()) {
            return false;
        }
        Term rhsTerm = assignment.get().getRhs();
        if (rhsTerm == reference) {
            return true;
        }
        if (rhsTerm == null) {
            return false;
        }
        TreeIterator iter = rhsTerm.eAllContents();
        while (iter.hasNext()) {
            if (iter.next() != reference) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    protected static interface IScopeProcessor {
        public IScope apply(EObject var1, EReference var2, IScope var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface IScopeProcessorMethod {
    }
}

