/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dataflow.dictionary.characterized.dsl.scoping;

import com.google.common.collect.Iterables;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class TransformingScope
implements IScope {
    private final IScope delegate;
    private final Function<IEObjectDescription, IEObjectDescription> transformation;

    public TransformingScope(IScope delegate, Function<IEObjectDescription, IEObjectDescription> transformation) {
        this.delegate = delegate;
        this.transformation = transformation;
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return this.transform(this.delegate.getAllElements());
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return this.transform(this.delegate.getElements(object));
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return Iterables.filter(this.getAllElements(), description -> description.getName().equals((Object)name));
    }

    public IEObjectDescription getSingleElement(EObject object) {
        return this.transform(this.delegate.getSingleElement(object));
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        return (IEObjectDescription)Iterables.getFirst(this.getElements(name), null);
    }

    protected Iterable<IEObjectDescription> transform(Iterable<IEObjectDescription> elements) {
        return Iterables.transform(elements, this.transformation::apply);
    }

    protected IEObjectDescription transform(IEObjectDescription element) {
        return this.transformation.apply(element);
    }
}

