/**
 */
package org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.util;

import de.uka.ipd.sdq.identifier.util.IdentifierValidator;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized.DataDictionaryCharacterizedPackage
 * @generated
 */
public class DataDictionaryCharacterizedValidator extends EObjectValidator
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final DataDictionaryCharacterizedValidator INSTANCE = new DataDictionaryCharacterizedValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.dataflow.dictionary.characterized.DataDictionaryCharacterized";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataDictionaryCharacterizedValidator()
	{
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage()
	{
	  return DataDictionaryCharacterizedPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		switch (classifierID)
		{
			case DataDictionaryCharacterizedPackage.ENTITY:
				return validateEntity((Entity)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.DATA_DICTIONARY_CHARACTERIZED:
				return validateDataDictionaryCharacterized((DataDictionaryCharacterized)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.CHARACTERISTIC_TYPE:
				return validateCharacteristicType((CharacteristicType)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.ENUM_CHARACTERISTIC_TYPE:
				return validateEnumCharacteristicType((EnumCharacteristicType)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.ENUMERATION:
				return validateEnumeration((Enumeration)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.LITERAL:
				return validateLiteral((Literal)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.BEHAVIOR_DEFINITION:
				return validateBehaviorDefinition((BehaviorDefinition)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.PIN:
				return validatePin((Pin)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.ASSIGNMENT:
				return validateAssignment((Assignment)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.CHARACTERISTIC:
				return validateCharacteristic((Characteristic)value, diagnostics, context);
			case DataDictionaryCharacterizedPackage.ENUM_CHARACTERISTIC:
				return validateEnumCharacteristic((EnumCharacteristic)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEntity(Entity entity, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)entity, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)entity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)entity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)entity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)entity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)entity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)entity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)entity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)entity, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(entity, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataDictionaryCharacterized(DataDictionaryCharacterized dataDictionaryCharacterized, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)dataDictionaryCharacterized, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)dataDictionaryCharacterized, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)dataDictionaryCharacterized, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)dataDictionaryCharacterized, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)dataDictionaryCharacterized, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)dataDictionaryCharacterized, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)dataDictionaryCharacterized, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)dataDictionaryCharacterized, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)dataDictionaryCharacterized, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataDictionaryCharacterized, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCharacteristicType(CharacteristicType characteristicType, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)characteristicType, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)characteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)characteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)characteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)characteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)characteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)characteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)characteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)characteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(characteristicType, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEnumCharacteristicType(EnumCharacteristicType enumCharacteristicType, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)enumCharacteristicType, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)enumCharacteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)enumCharacteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)enumCharacteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)enumCharacteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)enumCharacteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)enumCharacteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)enumCharacteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)enumCharacteristicType, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(enumCharacteristicType, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEnumeration(Enumeration enumeration, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)enumeration, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)enumeration, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)enumeration, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)enumeration, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)enumeration, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)enumeration, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)enumeration, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)enumeration, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)enumeration, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(enumeration, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLiteral(Literal literal, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)literal, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)literal, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)literal, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)literal, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)literal, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)literal, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)literal, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)literal, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)literal, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(literal, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBehaviorDefinition(BehaviorDefinition behaviorDefinition, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)behaviorDefinition, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)behaviorDefinition, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)behaviorDefinition, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)behaviorDefinition, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)behaviorDefinition, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)behaviorDefinition, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)behaviorDefinition, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)behaviorDefinition, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)behaviorDefinition, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(behaviorDefinition, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePin(Pin pin, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)pin, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)pin, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)pin, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)pin, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)pin, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)pin, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)pin, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)pin, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)pin, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(pin, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssignment(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)assignment, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)assignment, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validateAssignment_leftHandSideRefersOutputPin(assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validateAssignment_characteristicWildcardHasToBeOnLhsAndRhs(assignment, diagnostics, context);
		if (result || diagnostics != null) result &= validateAssignment_literalWildcardHasToBeOnLhsAndRhs(assignment, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the leftHandSideRefersOutputPin constraint of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String ASSIGNMENT__LEFT_HAND_SIDE_REFERS_OUTPUT_PIN__EEXPRESSION = "self.oclAsType(ecore::EObject).eContainer().oclAsType(BehaviorDefinition).outputs->includes(self.lhs.pin)";

	/**
	 * Validates the leftHandSideRefersOutputPin constraint of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssignment_leftHandSideRefersOutputPin(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(DataDictionaryCharacterizedPackage.Literals.ASSIGNMENT,
				 (EObject)assignment,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "leftHandSideRefersOutputPin",
				 ASSIGNMENT__LEFT_HAND_SIDE_REFERS_OUTPUT_PIN__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the characteristicWildcardHasToBeOnLhsAndRhs constraint of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String ASSIGNMENT__CHARACTERISTIC_WILDCARD_HAS_TO_BE_ON_LHS_AND_RHS__EEXPRESSION = "not self.rhs.oclIsKindOf(expressions::CharacteristicReference) or\n" +
		"(\n" +
		"\tself.rhs.oclAsType(expressions::CharacteristicReference).characteristicType.oclIsUndefined()\n" +
		"\tand\n" +
		"\tself.lhs.characteristicType.oclIsUndefined()\n" +
		")\n" +
		"or\n" +
		"(\n" +
		"\tnot self.rhs.oclAsType(expressions::CharacteristicReference).characteristicType.oclIsUndefined()\n" +
		"\tand\n" +
		"\tnot self.lhs.characteristicType.oclIsUndefined()\n" +
		")";

	/**
	 * Validates the characteristicWildcardHasToBeOnLhsAndRhs constraint of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssignment_characteristicWildcardHasToBeOnLhsAndRhs(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(DataDictionaryCharacterizedPackage.Literals.ASSIGNMENT,
				 (EObject)assignment,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "characteristicWildcardHasToBeOnLhsAndRhs",
				 ASSIGNMENT__CHARACTERISTIC_WILDCARD_HAS_TO_BE_ON_LHS_AND_RHS__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the literalWildcardHasToBeOnLhsAndRhs constraint of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String ASSIGNMENT__LITERAL_WILDCARD_HAS_TO_BE_ON_LHS_AND_RHS__EEXPRESSION = "not self.rhs.oclIsKindOf(expressions::EnumCharacteristicReference) or\n" +
		"(\n" +
		"\tself.rhs.oclAsType(expressions::EnumCharacteristicReference).literal.oclIsUndefined()\n" +
		"\tand\n" +
		"\tself.lhs.literal.oclIsUndefined()\n" +
		")\n" +
		"or\n" +
		"(\n" +
		"\tnot self.rhs.oclAsType(expressions::EnumCharacteristicReference).literal.oclIsUndefined()\n" +
		"\tand\n" +
		"\tnot self.lhs.literal.oclIsUndefined()\n" +
		")";

	/**
	 * Validates the literalWildcardHasToBeOnLhsAndRhs constraint of '<em>Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssignment_literalWildcardHasToBeOnLhsAndRhs(Assignment assignment, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(DataDictionaryCharacterizedPackage.Literals.ASSIGNMENT,
				 (EObject)assignment,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG",
				 "literalWildcardHasToBeOnLhsAndRhs",
				 ASSIGNMENT__LITERAL_WILDCARD_HAS_TO_BE_ON_LHS_AND_RHS__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCharacteristic(Characteristic characteristic, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)characteristic, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)characteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)characteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)characteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)characteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)characteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)characteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)characteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)characteristic, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(characteristic, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEnumCharacteristic(EnumCharacteristic enumCharacteristic, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)enumCharacteristic, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)enumCharacteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)enumCharacteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)enumCharacteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)enumCharacteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)enumCharacteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)enumCharacteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)enumCharacteristic, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)enumCharacteristic, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(enumCharacteristic, diagnostics, context);
		return result;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator()
	{
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //DataDictionaryCharacterizedValidator
